@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetReportByResourceGroupNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property reportName Report Name.
 * @property resourceGroupName Azure Resource Group Name.
 */
public data class GetReportByResourceGroupNamePlainArgs(
    public val reportName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetReportByResourceGroupNamePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.costmanagement.inputs.GetReportByResourceGroupNamePlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetReportByResourceGroupNamePlainArgs.builder()
            .reportName(reportName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReportByResourceGroupNamePlainArgs].
 */
@PulumiTagMarker
public class GetReportByResourceGroupNamePlainArgsBuilder internal constructor() {
    private var reportName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Report Name.
     */
    @JvmName("xnhwgeiubtbyoueb")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    /**
     * @param value Azure Resource Group Name.
     */
    @JvmName("xkcnlkwoclcrvvyr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetReportByResourceGroupNamePlainArgs =
        GetReportByResourceGroupNamePlainArgs(
            reportName = reportName ?: throw PulumiNullFieldException("reportName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
