@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetScheduledActionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Scheduled action name.
 */
public data class GetScheduledActionPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetScheduledActionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetScheduledActionPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetScheduledActionPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScheduledActionPlainArgs].
 */
@PulumiTagMarker
public class GetScheduledActionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Scheduled action name.
     */
    @JvmName("xnpvvmyejmgjrgne")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetScheduledActionPlainArgs = GetScheduledActionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
