@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration of dataset in the report.
 * @property columns Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
 */
public data class ReportConfigDatasetConfigurationArgs(
    public val columns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetConfigurationArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetConfigurationArgs.builder()
            .columns(columns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ReportConfigDatasetConfigurationArgs].
 */
@PulumiTagMarker
public class ReportConfigDatasetConfigurationArgsBuilder internal constructor() {
    private var columns: Output<List<String>>? = null

    /**
     * @param value Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("caaybibdsynthcmu")
    public suspend fun columns(`value`: Output<List<String>>) {
        this.columns = value
    }

    @JvmName("deparhwynapgnrrx")
    public suspend fun columns(vararg values: Output<String>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("bixgrvsmlexgorcu")
    public suspend fun columns(values: List<Output<String>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("iuxyttgjonupygwf")
    public suspend fun columns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param values Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("aywxhhladhccysdf")
    public suspend fun columns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    internal fun build(): ReportConfigDatasetConfigurationArgs = ReportConfigDatasetConfigurationArgs(
        columns = columns,
    )
}
