@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The filter expression to be used in the report.
 * @property and The logical "AND" expression. Must have at least 2 items.
 * @property dimensions Has comparison expression for a dimension
 * @property or The logical "OR" expression. Must have at least 2 items.
 * @property tags Has comparison expression for a tag
 */
public data class ReportConfigFilterArgs(
    public val and: Output<List<ReportConfigFilterArgs>>? = null,
    public val dimensions: Output<ReportConfigComparisonExpressionArgs>? = null,
    public val or: Output<List<ReportConfigFilterArgs>>? = null,
    public val tags: Output<ReportConfigComparisonExpressionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportConfigFilterArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigFilterArgs.builder()
            .and(and?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .dimensions(dimensions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .or(or?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReportConfigFilterArgs].
 */
@PulumiTagMarker
public class ReportConfigFilterArgsBuilder internal constructor() {
    private var and: Output<List<ReportConfigFilterArgs>>? = null

    private var dimensions: Output<ReportConfigComparisonExpressionArgs>? = null

    private var or: Output<List<ReportConfigFilterArgs>>? = null

    private var tags: Output<ReportConfigComparisonExpressionArgs>? = null

    /**
     * @param value The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("fserlygwrnmllsab")
    public suspend fun and(`value`: Output<List<ReportConfigFilterArgs>>) {
        this.and = value
    }

    @JvmName("yxayuqcnqkxnvanw")
    public suspend fun and(vararg values: Output<ReportConfigFilterArgs>) {
        this.and = Output.all(values.asList())
    }

    /**
     * @param values The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("xifubwartnohaihb")
    public suspend fun and(values: List<Output<ReportConfigFilterArgs>>) {
        this.and = Output.all(values)
    }

    /**
     * @param value Has comparison expression for a dimension
     */
    @JvmName("bidktlecgwigrdeb")
    public suspend fun dimensions(`value`: Output<ReportConfigComparisonExpressionArgs>) {
        this.dimensions = value
    }

    /**
     * @param value The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("qffvoglpyejcgsfx")
    public suspend fun or(`value`: Output<List<ReportConfigFilterArgs>>) {
        this.or = value
    }

    @JvmName("pkfqbjpbolwcfant")
    public suspend fun or(vararg values: Output<ReportConfigFilterArgs>) {
        this.or = Output.all(values.asList())
    }

    /**
     * @param values The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("jtlsgqqnfqmunoxd")
    public suspend fun or(values: List<Output<ReportConfigFilterArgs>>) {
        this.or = Output.all(values)
    }

    /**
     * @param value Has comparison expression for a tag
     */
    @JvmName("apqyispjvxwonckm")
    public suspend fun tags(`value`: Output<ReportConfigComparisonExpressionArgs>) {
        this.tags = value
    }

    /**
     * @param value The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("hiyhvkpaijeqqwup")
    public suspend fun and(`value`: List<ReportConfigFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("wtvtbqjbykcgibmn")
    public suspend fun and(argument: List<suspend ReportConfigFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportConfigFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("vaeincsfdtlmggul")
    public suspend fun and(vararg argument: suspend ReportConfigFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportConfigFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("rsnajqjikbbyndmy")
    public suspend fun and(argument: suspend ReportConfigFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportConfigFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param values The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("dyolupwtuvwxttds")
    public suspend fun and(vararg values: ReportConfigFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param value Has comparison expression for a dimension
     */
    @JvmName("hqhrayvacejddrcr")
    public suspend fun dimensions(`value`: ReportConfigComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Has comparison expression for a dimension
     */
    @JvmName("qiqwqtpjkmptvvgc")
    public suspend
    fun dimensions(argument: suspend ReportConfigComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ReportConfigComparisonExpressionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param value The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("qbltycnhnlpifgjx")
    public suspend fun or(`value`: List<ReportConfigFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.or = mapped
    }

    /**
     * @param argument The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("xsypfssdcsnxcgio")
    public suspend fun or(argument: List<suspend ReportConfigFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportConfigFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.or = mapped
    }

    /**
     * @param argument The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("fwtolsligpugbfmp")
    public suspend fun or(vararg argument: suspend ReportConfigFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportConfigFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.or = mapped
    }

    /**
     * @param argument The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("kqxdtslttelapeen")
    public suspend fun or(argument: suspend ReportConfigFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportConfigFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.or = mapped
    }

    /**
     * @param values The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("mdpuhiwdqfbfuspt")
    public suspend fun or(vararg values: ReportConfigFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.or = mapped
    }

    /**
     * @param value Has comparison expression for a tag
     */
    @JvmName("kbxrbtnfejcgoqqw")
    public suspend fun tags(`value`: ReportConfigComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Has comparison expression for a tag
     */
    @JvmName("osqyycbsrwbqpmrw")
    public suspend
    fun tags(argument: suspend ReportConfigComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ReportConfigComparisonExpressionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): ReportConfigFilterArgs = ReportConfigFilterArgs(
        and = and,
        dimensions = dimensions,
        or = or,
        tags = tags,
    )
}
