@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigTimePeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The start and end date for pulling data for the report.
 * @property from The start date to pull data from.
 * @property to The end date to pull data to.
 */
public data class ReportConfigTimePeriodArgs(
    public val from: Output<String>,
    public val to: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigTimePeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportConfigTimePeriodArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigTimePeriodArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportConfigTimePeriodArgs].
 */
@PulumiTagMarker
public class ReportConfigTimePeriodArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value The start date to pull data from.
     */
    @JvmName("snjebautttawkunv")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value The end date to pull data to.
     */
    @JvmName("lyfbyhqrijdcvfcp")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value The start date to pull data from.
     */
    @JvmName("jqedvabscdkqbtli")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value The end date to pull data to.
     */
    @JvmName("meyxeudedwuqxfug")
    public suspend fun to(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): ReportConfigTimePeriodArgs = ReportConfigTimePeriodArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
