@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportDatasetConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration of dataset in the report.
 * @property columns Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
 */
public data class ReportDatasetConfigurationArgs(
    public val columns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportDatasetConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportDatasetConfigurationArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportDatasetConfigurationArgs.builder()
            .columns(columns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ReportDatasetConfigurationArgs].
 */
@PulumiTagMarker
public class ReportDatasetConfigurationArgsBuilder internal constructor() {
    private var columns: Output<List<String>>? = null

    /**
     * @param value Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("gfachjusahvqrivn")
    public suspend fun columns(`value`: Output<List<String>>) {
        this.columns = value
    }

    @JvmName("gqacjbrgxuuuliym")
    public suspend fun columns(vararg values: Output<String>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("cmhkysfcgcwxjfcj")
    public suspend fun columns(values: List<Output<String>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("naxyxomlnfpqjwxo")
    public suspend fun columns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param values Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
     */
    @JvmName("raiwwdnvqpypvqbk")
    public suspend fun columns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    internal fun build(): ReportDatasetConfigurationArgs = ReportDatasetConfigurationArgs(
        columns = columns,
    )
}
