@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The destination information for the delivery of the report.
 * @property container The name of the container where reports will be uploaded.
 * @property resourceId The resource id of the storage account where reports will be delivered.
 * @property rootFolderPath The name of the directory where reports will be uploaded.
 */
public data class ReportDeliveryDestinationArgs(
    public val container: Output<String>,
    public val resourceId: Output<String>,
    public val rootFolderPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryDestinationArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryDestinationArgs.builder()
            .container(container.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .rootFolderPath(rootFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportDeliveryDestinationArgs].
 */
@PulumiTagMarker
public class ReportDeliveryDestinationArgsBuilder internal constructor() {
    private var container: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var rootFolderPath: Output<String>? = null

    /**
     * @param value The name of the container where reports will be uploaded.
     */
    @JvmName("gbrmhhpmtgaxnquc")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value The resource id of the storage account where reports will be delivered.
     */
    @JvmName("mqhiipqqyhsjsbyw")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the directory where reports will be uploaded.
     */
    @JvmName("ckmqspboegkhqlye")
    public suspend fun rootFolderPath(`value`: Output<String>) {
        this.rootFolderPath = value
    }

    /**
     * @param value The name of the container where reports will be uploaded.
     */
    @JvmName("dsnfteqgxdpiyprt")
    public suspend fun container(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value The resource id of the storage account where reports will be delivered.
     */
    @JvmName("saskhxltfiquqepp")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The name of the directory where reports will be uploaded.
     */
    @JvmName("eikpnslgydqfofyr")
    public suspend fun rootFolderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootFolderPath = mapped
    }

    internal fun build(): ReportDeliveryDestinationArgs = ReportDeliveryDestinationArgs(
        container = container ?: throw PulumiNullFieldException("container"),
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        rootFolderPath = rootFolderPath,
    )
}
