@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The comparison expression to be used in the budgets.
 * @property name The name of the column to use in comparison.
 * @property operator The operator to use for comparison.
 * @property values Array of values to use for comparison
 */
public data class BudgetComparisonExpressionResponse(
    public val name: String,
    public val `operator`: String,
    public val values: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.BudgetComparisonExpressionResponse):
            BudgetComparisonExpressionResponse = BudgetComparisonExpressionResponse(
            name = javaType.name(),
            `operator` = javaType.`operator`(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
