@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Scheduled action definition.
 * @property displayName Scheduled action name.
 * @property eTag Resource Etag. For update calls, eTag is optional and can be specified to achieve optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then including the latest eTag as part of the request body or 'If-Match' header while performing the update. For create calls, eTag is not required.
 * @property fileDestination Destination format of the view data. This is optional.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Kind of the scheduled action.
 * @property name The name of the resource
 * @property notification Notification properties based on scheduled action kind.
 * @property notificationEmail Email address of the point of contact that should get the unsubscribe requests and notification emails.
 * @property schedule Schedule of the scheduled action.
 * @property scope For private scheduled action(Create or Update), scope will be empty.<br /> For shared scheduled action(Create or Update By Scope), Cost Management scope can be 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
 * @property status Status of the scheduled action.
 * @property systemData Kind of the scheduled action.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property viewId Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'
 */
public data class GetScheduledActionByScopeResult(
    public val displayName: String,
    public val eTag: String,
    public val fileDestination: FileDestinationResponse? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val notification: NotificationPropertiesResponse,
    public val notificationEmail: String? = null,
    public val schedule: SchedulePropertiesResponse,
    public val scope: String? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val viewId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetScheduledActionByScopeResult):
            GetScheduledActionByScopeResult = GetScheduledActionByScopeResult(
            displayName = javaType.displayName(),
            eTag = javaType.eTag(),
            fileDestination = javaType.fileDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.FileDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notification = javaType.notification().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.NotificationPropertiesResponse.Companion.toKotlin(args0)
            }),
            notificationEmail = javaType.notificationEmail().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.SchedulePropertiesResponse.Companion.toKotlin(args0)
            }),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            viewId = javaType.viewId(),
        )
    }
}
