@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Each KPI must contain a 'type' and 'enabled' key.
 * @property enabled show the KPI in the UI?
 * @property id ID of resource related to metric (budget).
 * @property type KPI type (Forecast, Budget).
 */
public data class KpiPropertiesResponse(
    public val enabled: Boolean? = null,
    public val id: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.KpiPropertiesResponse):
            KpiPropertiesResponse = KpiPropertiesResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
