@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The destination information for the delivery of the report.
 * @property container The name of the container where reports will be uploaded.
 * @property resourceId The resource id of the storage account where reports will be delivered.
 * @property rootFolderPath The name of the directory where reports will be uploaded.
 */
public data class ReportDeliveryDestinationResponse(
    public val container: String,
    public val resourceId: String,
    public val rootFolderPath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportDeliveryDestinationResponse):
            ReportDeliveryDestinationResponse = ReportDeliveryDestinationResponse(
            container = javaType.container(),
            resourceId = javaType.resourceId(),
            rootFolderPath = javaType.rootFolderPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
