@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property channel Indicates the account type. Allowed values include: EA, PAYG, Modern, Internal, Unknown.
 * @property id Resource ID used by Resource Manager to uniquely identify the scope.
 * @property name Display name for the scope.
 * @property parent Resource ID of the parent scope. For instance, subscription's resource ID for a resource group or a management group resource ID for a subscription.
 * @property status Indicates the status of the scope. Status only applies to subscriptions and billing accounts.
 * @property subchannel Indicates the type of modern account. Allowed values include: Individual, Enterprise, Partner, Indirect, NotApplicable
 */
public data class SettingsPropertiesResponseCache(
    public val channel: String,
    public val id: String,
    public val name: String,
    public val parent: String? = null,
    public val status: String? = null,
    public val subchannel: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.SettingsPropertiesResponseCache):
            SettingsPropertiesResponseCache = SettingsPropertiesResponseCache(
            channel = javaType.channel(),
            id = javaType.id(),
            name = javaType.name(),
            parent = javaType.parent().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subchannel = javaType.subchannel(),
        )
    }
}
