@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.ConnectorArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.ConnectorTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The connector resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Connectors_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.CustomerInsights.Connector("connector", new()
 *     {
 *         ConnectorName = "testConnector",
 *         ConnectorProperties =
 *         {
 *             { "connectionKeyVaultUrl",
 *             {
 *                 { "organizationId", "XXX" },
 *                 { "organizationUrl", "https://XXX.crmlivetie.com/" },
 *             } },
 *         },
 *         ConnectorType = "AzureBlob",
 *         Description = "Test connector",
 *         DisplayName = "testConnector",
 *         HubName = "sdkTestHub",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewConnector(ctx, "connector", &customerinsights.ConnectorArgs{
 * 			ConnectorName: pulumi.String("testConnector"),
 * 			ConnectorProperties: pulumi.Map{
 * 				"connectionKeyVaultUrl": pulumi.Any{
 * 					OrganizationId:  "XXX",
 * 					OrganizationUrl: "https://XXX.crmlivetie.com/",
 * 				},
 * 			},
 * 			ConnectorType:     pulumi.String("AzureBlob"),
 * 			Description:       pulumi.String("Test connector"),
 * 			DisplayName:       pulumi.String("testConnector"),
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Connector;
 * import com.pulumi.azurenative.customerinsights.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .connectorName("testConnector")
 *             .connectorProperties(Map.of("connectionKeyVaultUrl", Map.ofEntries(
 *                 Map.entry("organizationId", "XXX"),
 *                 Map.entry("organizationUrl", "https://XXX.crmlivetie.com/")
 *             )))
 *             .connectorType("AzureBlob")
 *             .description("Test connector")
 *             .displayName("testConnector")
 *             .hubName("sdkTestHub")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Connector sdkTestHub/testConnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}
 * ```
 * @property connectorName Name of the connector.
 * @property connectorProperties The connector properties.
 * @property connectorType Type of connector.
 * @property description Description of the connector.
 * @property displayName Display name of the connector.
 * @property hubName The name of the hub.
 * @property isInternal If this is an internal connector.
 * @property resourceGroupName The name of the resource group.
 */
public data class ConnectorArgs(
    public val connectorName: Output<String>? = null,
    public val connectorProperties: Output<Map<String, Any>>? = null,
    public val connectorType: Output<Either<String, ConnectorTypes>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val hubName: Output<String>? = null,
    public val isInternal: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.ConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.ConnectorArgs =
        com.pulumi.azurenative.customerinsights.ConnectorArgs.builder()
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .connectorProperties(
                connectorProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .connectorType(
                connectorType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .isInternal(isInternal?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var connectorName: Output<String>? = null

    private var connectorProperties: Output<Map<String, Any>>? = null

    private var connectorType: Output<Either<String, ConnectorTypes>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var hubName: Output<String>? = null

    private var isInternal: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the connector.
     */
    @JvmName("uevbsyxxkouupsoo")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value The connector properties.
     */
    @JvmName("umkujdwidvdsmlph")
    public suspend fun connectorProperties(`value`: Output<Map<String, Any>>) {
        this.connectorProperties = value
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("kbgjipwstjarclxj")
    public suspend fun connectorType(`value`: Output<Either<String, ConnectorTypes>>) {
        this.connectorType = value
    }

    /**
     * @param value Description of the connector.
     */
    @JvmName("rkqgalemgxsvuyhg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of the connector.
     */
    @JvmName("kxkwmqjddgdsmfrg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("upksgveaexjjhtgh")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value If this is an internal connector.
     */
    @JvmName("adwemrfyufpllqlp")
    public suspend fun isInternal(`value`: Output<Boolean>) {
        this.isInternal = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("itlqixmvcsbmgtyq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the connector.
     */
    @JvmName("sxkeuccojhxjpcvv")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value The connector properties.
     */
    @JvmName("jsmhrxkhquijvqfj")
    public suspend fun connectorProperties(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorProperties = mapped
    }

    /**
     * @param values The connector properties.
     */
    @JvmName("ngerdrahqtiaxyya")
    public fun connectorProperties(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorProperties = mapped
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("bnodrgvlpeqjyuwi")
    public suspend fun connectorType(`value`: Either<String, ConnectorTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("pnfwaoljgdirqfqq")
    public fun connectorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectorTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("wsnpivbmjpoylapn")
    public fun connectorType(`value`: ConnectorTypes) {
        val toBeMapped = Either.ofRight<String, ConnectorTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Description of the connector.
     */
    @JvmName("filjlotlnxutwqxk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of the connector.
     */
    @JvmName("enudyoufnykhumhy")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("hbhkbhdsdjbcuskl")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value If this is an internal connector.
     */
    @JvmName("ebqqfmeqhuaqydjc")
    public suspend fun isInternal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isInternal = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("urlbxykhbnuqqnve")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        connectorName = connectorName,
        connectorProperties = connectorProperties,
        connectorType = connectorType,
        description = description,
        displayName = displayName,
        hubName = hubName,
        isInternal = isInternal,
        resourceGroupName = resourceGroupName,
    )
}
