@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.RelationshipArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.CardinalityTypes
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PropertyDefinitionArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PropertyDefinitionArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.RelationshipTypeMappingArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.RelationshipTypeMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The relationship resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Relationships_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var relationship = new AzureNative.CustomerInsights.Relationship("relationship", new()
 *     {
 *         Cardinality = AzureNative.CustomerInsights.CardinalityTypes.OneToOne,
 *         Description =
 *         {
 *             { "en-us", "Relationship Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Relationship DisplayName" },
 *         },
 *         Fields = new[] {},
 *         HubName = "sdkTestHub",
 *         ProfileType = "testProfile2326994",
 *         RelatedProfileType = "testProfile2326994",
 *         RelationshipName = "SomeRelationship",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewRelationship(ctx, "relationship", &customerinsights.RelationshipArgs{
 * 			Cardinality: customerinsights.CardinalityTypesOneToOne,
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Relationship Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Relationship DisplayName"),
 * 			},
 * 			Fields:             customerinsights.PropertyDefinitionArray{},
 * 			HubName:            pulumi.String("sdkTestHub"),
 * 			ProfileType:        pulumi.String("testProfile2326994"),
 * 			RelatedProfileType: pulumi.String("testProfile2326994"),
 * 			RelationshipName:   pulumi.String("SomeRelationship"),
 * 			ResourceGroupName:  pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Relationship;
 * import com.pulumi.azurenative.customerinsights.RelationshipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var relationship = new Relationship("relationship", RelationshipArgs.builder()
 *             .cardinality("OneToOne")
 *             .description(Map.of("en-us", "Relationship Description"))
 *             .displayName(Map.of("en-us", "Relationship DisplayName"))
 *             .fields()
 *             .hubName("sdkTestHub")
 *             .profileType("testProfile2326994")
 *             .relatedProfileType("testProfile2326994")
 *             .relationshipName("SomeRelationship")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Relationship sdkTestHub/testProfile2326994 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}
 * ```
 * @property cardinality The Relationship Cardinality.
 * @property description Localized descriptions for the Relationship.
 * @property displayName Localized display name for the Relationship.
 * @property expiryDateTimeUtc The expiry date time in UTC.
 * @property fields The properties of the Relationship.
 * @property hubName The name of the hub.
 * @property lookupMappings Optional property to be used to map fields in profile to their strong ids in related profile.
 * @property profileType Profile type.
 * @property relatedProfileType Related profile being referenced.
 * @property relationshipName The name of the Relationship.
 * @property resourceGroupName The name of the resource group.
 */
public data class RelationshipArgs(
    public val cardinality: Output<CardinalityTypes>? = null,
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val expiryDateTimeUtc: Output<String>? = null,
    public val fields: Output<List<PropertyDefinitionArgs>>? = null,
    public val hubName: Output<String>? = null,
    public val lookupMappings: Output<List<RelationshipTypeMappingArgs>>? = null,
    public val profileType: Output<String>? = null,
    public val relatedProfileType: Output<String>? = null,
    public val relationshipName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.RelationshipArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.RelationshipArgs =
        com.pulumi.azurenative.customerinsights.RelationshipArgs.builder()
            .cardinality(cardinality?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .expiryDateTimeUtc(expiryDateTimeUtc?.applyValue({ args0 -> args0 }))
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .lookupMappings(
                lookupMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .profileType(profileType?.applyValue({ args0 -> args0 }))
            .relatedProfileType(relatedProfileType?.applyValue({ args0 -> args0 }))
            .relationshipName(relationshipName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RelationshipArgs].
 */
@PulumiTagMarker
public class RelationshipArgsBuilder internal constructor() {
    private var cardinality: Output<CardinalityTypes>? = null

    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var expiryDateTimeUtc: Output<String>? = null

    private var fields: Output<List<PropertyDefinitionArgs>>? = null

    private var hubName: Output<String>? = null

    private var lookupMappings: Output<List<RelationshipTypeMappingArgs>>? = null

    private var profileType: Output<String>? = null

    private var relatedProfileType: Output<String>? = null

    private var relationshipName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Relationship Cardinality.
     */
    @JvmName("pjtilnduwwvnmxsn")
    public suspend fun cardinality(`value`: Output<CardinalityTypes>) {
        this.cardinality = value
    }

    /**
     * @param value Localized descriptions for the Relationship.
     */
    @JvmName("lirsflueimvrkolf")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display name for the Relationship.
     */
    @JvmName("fghskytfirefppxq")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The expiry date time in UTC.
     */
    @JvmName("tgpwyoigmholtdte")
    public suspend fun expiryDateTimeUtc(`value`: Output<String>) {
        this.expiryDateTimeUtc = value
    }

    /**
     * @param value The properties of the Relationship.
     */
    @JvmName("drxfqioxfjbkmapl")
    public suspend fun fields(`value`: Output<List<PropertyDefinitionArgs>>) {
        this.fields = value
    }

    @JvmName("dobhtrtgcenuhous")
    public suspend fun fields(vararg values: Output<PropertyDefinitionArgs>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values The properties of the Relationship.
     */
    @JvmName("fprdvvlssscjywed")
    public suspend fun fields(values: List<Output<PropertyDefinitionArgs>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("pprfhxvfixxluhbh")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("rkexcepllpyinhkk")
    public suspend fun lookupMappings(`value`: Output<List<RelationshipTypeMappingArgs>>) {
        this.lookupMappings = value
    }

    @JvmName("vqcmflhipclyntsd")
    public suspend fun lookupMappings(vararg values: Output<RelationshipTypeMappingArgs>) {
        this.lookupMappings = Output.all(values.asList())
    }

    /**
     * @param values Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("bihadurtipifnnrg")
    public suspend fun lookupMappings(values: List<Output<RelationshipTypeMappingArgs>>) {
        this.lookupMappings = Output.all(values)
    }

    /**
     * @param value Profile type.
     */
    @JvmName("vyhfoxfervbavspl")
    public suspend fun profileType(`value`: Output<String>) {
        this.profileType = value
    }

    /**
     * @param value Related profile being referenced.
     */
    @JvmName("fxwbvlhqcyidbbxg")
    public suspend fun relatedProfileType(`value`: Output<String>) {
        this.relatedProfileType = value
    }

    /**
     * @param value The name of the Relationship.
     */
    @JvmName("btexrxmpwvqonbrl")
    public suspend fun relationshipName(`value`: Output<String>) {
        this.relationshipName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lwrxuptknsuxgquj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Relationship Cardinality.
     */
    @JvmName("nyyxlexufsmrlcdq")
    public suspend fun cardinality(`value`: CardinalityTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cardinality = mapped
    }

    /**
     * @param value Localized descriptions for the Relationship.
     */
    @JvmName("wwajgvumbpupracg")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized descriptions for the Relationship.
     */
    @JvmName("shhitxpwxnmrkbqp")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display name for the Relationship.
     */
    @JvmName("yglianhtoypewbrc")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display name for the Relationship.
     */
    @JvmName("grdyvgirmkhngtlb")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The expiry date time in UTC.
     */
    @JvmName("nqagiyoiweawanme")
    public suspend fun expiryDateTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryDateTimeUtc = mapped
    }

    /**
     * @param value The properties of the Relationship.
     */
    @JvmName("dvaqrpvmdkcnbrvd")
    public suspend fun fields(`value`: List<PropertyDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param argument The properties of the Relationship.
     */
    @JvmName("lgdaloiharvxphhg")
    public suspend fun fields(argument: List<suspend PropertyDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PropertyDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument The properties of the Relationship.
     */
    @JvmName("gcxirgpmkedpciph")
    public suspend fun fields(vararg argument: suspend PropertyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PropertyDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument The properties of the Relationship.
     */
    @JvmName("pyaluykwuhtsklsl")
    public suspend fun fields(argument: suspend PropertyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PropertyDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param values The properties of the Relationship.
     */
    @JvmName("wgvcdawvjwsawklq")
    public suspend fun fields(vararg values: PropertyDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("ksmghgyarxsimwes")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("xkkdtdhqviubptde")
    public suspend fun lookupMappings(`value`: List<RelationshipTypeMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lookupMappings = mapped
    }

    /**
     * @param argument Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("yrkdetojonajrnkr")
    public suspend
    fun lookupMappings(argument: List<suspend RelationshipTypeMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RelationshipTypeMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lookupMappings = mapped
    }

    /**
     * @param argument Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("htgpveguuyusedlo")
    public suspend fun lookupMappings(
        vararg
        argument: suspend RelationshipTypeMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RelationshipTypeMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lookupMappings = mapped
    }

    /**
     * @param argument Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("fbojwuwqxnoucqrv")
    public suspend
    fun lookupMappings(argument: suspend RelationshipTypeMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RelationshipTypeMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lookupMappings = mapped
    }

    /**
     * @param values Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    @JvmName("pvxfwxwwnrtakemd")
    public suspend fun lookupMappings(vararg values: RelationshipTypeMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lookupMappings = mapped
    }

    /**
     * @param value Profile type.
     */
    @JvmName("bipkdyrecpwipmxn")
    public suspend fun profileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileType = mapped
    }

    /**
     * @param value Related profile being referenced.
     */
    @JvmName("ldgdwhemukdyhexd")
    public suspend fun relatedProfileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedProfileType = mapped
    }

    /**
     * @param value The name of the Relationship.
     */
    @JvmName("eculuuhimpfxpnsq")
    public suspend fun relationshipName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationshipName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tuxvjvqpuwwmdjim")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RelationshipArgs = RelationshipArgs(
        cardinality = cardinality,
        description = description,
        displayName = displayName,
        expiryDateTimeUtc = expiryDateTimeUtc,
        fields = fields,
        hubName = hubName,
        lookupMappings = lookupMappings,
        profileType = profileType,
        relatedProfileType = relatedProfileType,
        relationshipName = relationshipName,
        resourceGroupName = resourceGroupName,
    )
}
