@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.RelationshipLinkArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ParticipantProfilePropertyReferenceArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ParticipantProfilePropertyReferenceArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.RelationshipLinkFieldMappingArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.RelationshipLinkFieldMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The relationship link resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * Other available API versions: 2017-01-01.
 * ## Example Usage
 * ### RelationshipLinks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var relationshipLink = new AzureNative.CustomerInsights.RelationshipLink("relationshipLink", new()
 *     {
 *         Description =
 *         {
 *             { "en-us", "Link Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Link DisplayName" },
 *         },
 *         HubName = "sdkTestHub",
 *         InteractionType = "testInteraction4332",
 *         ProfilePropertyReferences = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.ParticipantProfilePropertyReferenceArgs
 *             {
 *                 InteractionPropertyName = "profile1",
 *                 ProfilePropertyName = "ProfileId",
 *             },
 *         },
 *         RelatedProfilePropertyReferences = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.ParticipantProfilePropertyReferenceArgs
 *             {
 *                 InteractionPropertyName = "profile1",
 *                 ProfilePropertyName = "ProfileId",
 *             },
 *         },
 *         RelationshipLinkName = "Somelink",
 *         RelationshipName = "testProfile2326994",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewRelationshipLink(ctx, "relationshipLink", &customerinsights.RelationshipLinkArgs{
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link DisplayName"),
 * 			},
 * 			HubName:         pulumi.String("sdkTestHub"),
 * 			InteractionType: pulumi.String("testInteraction4332"),
 * 			ProfilePropertyReferences: []customerinsights.ParticipantProfilePropertyReferenceArgs{
 * 				{
 * 					InteractionPropertyName: pulumi.String("profile1"),
 * 					ProfilePropertyName:     pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 			RelatedProfilePropertyReferences: []customerinsights.ParticipantProfilePropertyReferenceArgs{
 * 				{
 * 					InteractionPropertyName: pulumi.String("profile1"),
 * 					ProfilePropertyName:     pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 			RelationshipLinkName: pulumi.String("Somelink"),
 * 			RelationshipName:     pulumi.String("testProfile2326994"),
 * 			ResourceGroupName:    pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.RelationshipLink;
 * import com.pulumi.azurenative.customerinsights.RelationshipLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var relationshipLink = new RelationshipLink("relationshipLink", RelationshipLinkArgs.builder()
 *             .description(Map.of("en-us", "Link Description"))
 *             .displayName(Map.of("en-us", "Link DisplayName"))
 *             .hubName("sdkTestHub")
 *             .interactionType("testInteraction4332")
 *             .profilePropertyReferences(Map.ofEntries(
 *                 Map.entry("interactionPropertyName", "profile1"),
 *                 Map.entry("profilePropertyName", "ProfileId")
 *             ))
 *             .relatedProfilePropertyReferences(Map.ofEntries(
 *                 Map.entry("interactionPropertyName", "profile1"),
 *                 Map.entry("profilePropertyName", "ProfileId")
 *             ))
 *             .relationshipLinkName("Somelink")
 *             .relationshipName("testProfile2326994")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:RelationshipLink sdkTestHub/Somelink /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}
 * ```
 * @property description Localized descriptions for the Relationship Link.
 * @property displayName Localized display name for the Relationship Link.
 * @property hubName The name of the hub.
 * @property interactionType The InteractionType associated with the Relationship Link.
 * @property mappings The mappings between Interaction and Relationship fields.
 * @property profilePropertyReferences The property references for the Profile of the Relationship.
 * @property relatedProfilePropertyReferences The property references for the Related Profile of the Relationship.
 * @property relationshipLinkName The name of the relationship link.
 * @property relationshipName The Relationship associated with the Link.
 * @property resourceGroupName The name of the resource group.
 */
public data class RelationshipLinkArgs(
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val hubName: Output<String>? = null,
    public val interactionType: Output<String>? = null,
    public val mappings: Output<List<RelationshipLinkFieldMappingArgs>>? = null,
    public val profilePropertyReferences: Output<List<ParticipantProfilePropertyReferenceArgs>>? =
        null,
    public val relatedProfilePropertyReferences:
    Output<List<ParticipantProfilePropertyReferenceArgs>>? = null,
    public val relationshipLinkName: Output<String>? = null,
    public val relationshipName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.RelationshipLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.RelationshipLinkArgs =
        com.pulumi.azurenative.customerinsights.RelationshipLinkArgs.builder()
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .interactionType(interactionType?.applyValue({ args0 -> args0 }))
            .mappings(
                mappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .profilePropertyReferences(
                profilePropertyReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .relatedProfilePropertyReferences(
                relatedProfilePropertyReferences?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .relationshipLinkName(relationshipLinkName?.applyValue({ args0 -> args0 }))
            .relationshipName(relationshipName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RelationshipLinkArgs].
 */
@PulumiTagMarker
public class RelationshipLinkArgsBuilder internal constructor() {
    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var hubName: Output<String>? = null

    private var interactionType: Output<String>? = null

    private var mappings: Output<List<RelationshipLinkFieldMappingArgs>>? = null

    private var profilePropertyReferences: Output<List<ParticipantProfilePropertyReferenceArgs>>? =
        null

    private var relatedProfilePropertyReferences:
        Output<List<ParticipantProfilePropertyReferenceArgs>>? = null

    private var relationshipLinkName: Output<String>? = null

    private var relationshipName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Localized descriptions for the Relationship Link.
     */
    @JvmName("otwstyffxqovqexv")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display name for the Relationship Link.
     */
    @JvmName("bcdcwtyrwwypqtgs")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("vmvuuliunkbenhpb")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value The InteractionType associated with the Relationship Link.
     */
    @JvmName("ytejirjgxwuenibp")
    public suspend fun interactionType(`value`: Output<String>) {
        this.interactionType = value
    }

    /**
     * @param value The mappings between Interaction and Relationship fields.
     */
    @JvmName("fofftvpxgfmbbmou")
    public suspend fun mappings(`value`: Output<List<RelationshipLinkFieldMappingArgs>>) {
        this.mappings = value
    }

    @JvmName("nfojrvqcskjqvlmi")
    public suspend fun mappings(vararg values: Output<RelationshipLinkFieldMappingArgs>) {
        this.mappings = Output.all(values.asList())
    }

    /**
     * @param values The mappings between Interaction and Relationship fields.
     */
    @JvmName("igyucpbnqstmxxpx")
    public suspend fun mappings(values: List<Output<RelationshipLinkFieldMappingArgs>>) {
        this.mappings = Output.all(values)
    }

    /**
     * @param value The property references for the Profile of the Relationship.
     */
    @JvmName("bqcyxgjyefvsprcg")
    public suspend
    fun profilePropertyReferences(`value`: Output<List<ParticipantProfilePropertyReferenceArgs>>) {
        this.profilePropertyReferences = value
    }

    @JvmName("tjsigjtieicietqw")
    public suspend fun profilePropertyReferences(
        vararg
        values: Output<ParticipantProfilePropertyReferenceArgs>,
    ) {
        this.profilePropertyReferences = Output.all(values.asList())
    }

    /**
     * @param values The property references for the Profile of the Relationship.
     */
    @JvmName("xbuargjmwvhltudj")
    public suspend
    fun profilePropertyReferences(values: List<Output<ParticipantProfilePropertyReferenceArgs>>) {
        this.profilePropertyReferences = Output.all(values)
    }

    /**
     * @param value The property references for the Related Profile of the Relationship.
     */
    @JvmName("uacbowwviedbqiws")
    public suspend
    fun relatedProfilePropertyReferences(`value`: Output<List<ParticipantProfilePropertyReferenceArgs>>) {
        this.relatedProfilePropertyReferences = value
    }

    @JvmName("lxjephljwqtagohn")
    public suspend fun relatedProfilePropertyReferences(
        vararg
        values: Output<ParticipantProfilePropertyReferenceArgs>,
    ) {
        this.relatedProfilePropertyReferences = Output.all(values.asList())
    }

    /**
     * @param values The property references for the Related Profile of the Relationship.
     */
    @JvmName("vqdbqagqnbskljfx")
    public suspend
    fun relatedProfilePropertyReferences(values: List<Output<ParticipantProfilePropertyReferenceArgs>>) {
        this.relatedProfilePropertyReferences = Output.all(values)
    }

    /**
     * @param value The name of the relationship link.
     */
    @JvmName("fclktpbkcjwjircg")
    public suspend fun relationshipLinkName(`value`: Output<String>) {
        this.relationshipLinkName = value
    }

    /**
     * @param value The Relationship associated with the Link.
     */
    @JvmName("vmkgxmeylsxnbwna")
    public suspend fun relationshipName(`value`: Output<String>) {
        this.relationshipName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qmvkpnhblenaynjy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Localized descriptions for the Relationship Link.
     */
    @JvmName("fxiwshtbwddpcawn")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized descriptions for the Relationship Link.
     */
    @JvmName("pfghkcddmiwbptod")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display name for the Relationship Link.
     */
    @JvmName("lksoovqgoernrjja")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display name for the Relationship Link.
     */
    @JvmName("whvjemeohbhprpqe")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("djppxipbmqegnbtc")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value The InteractionType associated with the Relationship Link.
     */
    @JvmName("huawbaobqoydopdt")
    public suspend fun interactionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interactionType = mapped
    }

    /**
     * @param value The mappings between Interaction and Relationship fields.
     */
    @JvmName("ahslbwpkhpfvgciq")
    public suspend fun mappings(`value`: List<RelationshipLinkFieldMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param argument The mappings between Interaction and Relationship fields.
     */
    @JvmName("ufbiaidkyphorvqu")
    public suspend
    fun mappings(argument: List<suspend RelationshipLinkFieldMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RelationshipLinkFieldMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param argument The mappings between Interaction and Relationship fields.
     */
    @JvmName("pcnrretsjcchkihu")
    public suspend fun mappings(
        vararg
        argument: suspend RelationshipLinkFieldMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RelationshipLinkFieldMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param argument The mappings between Interaction and Relationship fields.
     */
    @JvmName("anrxprxqkgeiwili")
    public suspend
    fun mappings(argument: suspend RelationshipLinkFieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RelationshipLinkFieldMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param values The mappings between Interaction and Relationship fields.
     */
    @JvmName("ymujlqfdqqyvxtgp")
    public suspend fun mappings(vararg values: RelationshipLinkFieldMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param value The property references for the Profile of the Relationship.
     */
    @JvmName("rkkwndymtjufdquo")
    public suspend
    fun profilePropertyReferences(`value`: List<ParticipantProfilePropertyReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profilePropertyReferences = mapped
    }

    /**
     * @param argument The property references for the Profile of the Relationship.
     */
    @JvmName("vimrjbemngwuwxuv")
    public suspend
    fun profilePropertyReferences(argument: List<suspend ParticipantProfilePropertyReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParticipantProfilePropertyReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.profilePropertyReferences = mapped
    }

    /**
     * @param argument The property references for the Profile of the Relationship.
     */
    @JvmName("srcappcsqntgmnbq")
    public suspend fun profilePropertyReferences(
        vararg
        argument: suspend ParticipantProfilePropertyReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParticipantProfilePropertyReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.profilePropertyReferences = mapped
    }

    /**
     * @param argument The property references for the Profile of the Relationship.
     */
    @JvmName("okkobprpfbrkbrwv")
    public suspend
    fun profilePropertyReferences(argument: suspend ParticipantProfilePropertyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParticipantProfilePropertyReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.profilePropertyReferences = mapped
    }

    /**
     * @param values The property references for the Profile of the Relationship.
     */
    @JvmName("wjgtsmpvxpipxesc")
    public suspend fun profilePropertyReferences(
        vararg
        values: ParticipantProfilePropertyReferenceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profilePropertyReferences = mapped
    }

    /**
     * @param value The property references for the Related Profile of the Relationship.
     */
    @JvmName("hfymlyooswhuaudx")
    public suspend
    fun relatedProfilePropertyReferences(`value`: List<ParticipantProfilePropertyReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedProfilePropertyReferences = mapped
    }

    /**
     * @param argument The property references for the Related Profile of the Relationship.
     */
    @JvmName("ddmatluythxxvyrb")
    public suspend
    fun relatedProfilePropertyReferences(argument: List<suspend ParticipantProfilePropertyReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParticipantProfilePropertyReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedProfilePropertyReferences = mapped
    }

    /**
     * @param argument The property references for the Related Profile of the Relationship.
     */
    @JvmName("sdrjwpifcdqcsryh")
    public suspend fun relatedProfilePropertyReferences(
        vararg
        argument: suspend ParticipantProfilePropertyReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParticipantProfilePropertyReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedProfilePropertyReferences = mapped
    }

    /**
     * @param argument The property references for the Related Profile of the Relationship.
     */
    @JvmName("kejyhsdscfdygqbt")
    public suspend
    fun relatedProfilePropertyReferences(argument: suspend ParticipantProfilePropertyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParticipantProfilePropertyReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.relatedProfilePropertyReferences = mapped
    }

    /**
     * @param values The property references for the Related Profile of the Relationship.
     */
    @JvmName("kqjkuijlxmjujrbc")
    public suspend fun relatedProfilePropertyReferences(
        vararg
        values: ParticipantProfilePropertyReferenceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedProfilePropertyReferences = mapped
    }

    /**
     * @param value The name of the relationship link.
     */
    @JvmName("uqilgbqrwjvipgok")
    public suspend fun relationshipLinkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationshipLinkName = mapped
    }

    /**
     * @param value The Relationship associated with the Link.
     */
    @JvmName("talepphyafofiltv")
    public suspend fun relationshipName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationshipName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xfjwjfcifxdljkga")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RelationshipLinkArgs = RelationshipLinkArgs(
        description = description,
        displayName = displayName,
        hubName = hubName,
        interactionType = interactionType,
        mappings = mappings,
        profilePropertyReferences = profilePropertyReferences,
        relatedProfilePropertyReferences = relatedProfilePropertyReferences,
        relationshipLinkName = relationshipLinkName,
        relationshipName = relationshipName,
        resourceGroupName = resourceGroupName,
    )
}
