@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.ViewArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The view resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Views_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var view = new AzureNative.CustomerInsights.View("view", new()
 *     {
 *         Definition = "{\\\"isProfileType\\\":false,\\\"profileTypes\\\":[],\\\"widgets\\\":[],\\\"style\\\":[]}",
 *         DisplayName =
 *         {
 *             { "en", "some name" },
 *         },
 *         HubName = "sdkTestHub",
 *         ResourceGroupName = "TestHubRG",
 *         UserId = "testUser",
 *         ViewName = "testView",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewView(ctx, "view", &customerinsights.ViewArgs{
 * 			Definition: pulumi.String("{\\\"isProfileType\\\":false,\\\"profileTypes\\\":[],\\\"widgets\\\":[],\\\"style\\\":[]}"),
 * 			DisplayName: pulumi.StringMap{
 * 				"en": pulumi.String("some name"),
 * 			},
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 			UserId:            pulumi.String("testUser"),
 * 			ViewName:          pulumi.String("testView"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.View;
 * import com.pulumi.azurenative.customerinsights.ViewArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var view = new View("view", ViewArgs.builder()
 *             .definition("{\\\"isProfileType\\\":false,\\\"profileTypes\\\":[],\\\"widgets\\\":[],\\\"style\\\":[]}")
 *             .displayName(Map.of("en", "some name"))
 *             .hubName("sdkTestHub")
 *             .resourceGroupName("TestHubRG")
 *             .userId("testUser")
 *             .viewName("testView")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:View sdkTestHub/testView /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}
 * ```
 * @property definition View definition.
 * @property displayName Localized display name for the view.
 * @property hubName The name of the hub.
 * @property resourceGroupName The name of the resource group.
 * @property userId the user ID.
 * @property viewName The name of the view.
 */
public data class ViewArgs(
    public val definition: Output<String>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val hubName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val userId: Output<String>? = null,
    public val viewName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.ViewArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.ViewArgs =
        com.pulumi.azurenative.customerinsights.ViewArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0 }))
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 }))
            .viewName(viewName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ViewArgs].
 */
@PulumiTagMarker
public class ViewArgsBuilder internal constructor() {
    private var definition: Output<String>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var hubName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var userId: Output<String>? = null

    private var viewName: Output<String>? = null

    /**
     * @param value View definition.
     */
    @JvmName("fthmiqshsamacnlu")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value Localized display name for the view.
     */
    @JvmName("pwotrpvnievehchs")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("nmguangxtwxjpeav")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("axidneflecdofest")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value the user ID.
     */
    @JvmName("ythrlahxmpfscoef")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value The name of the view.
     */
    @JvmName("ymeyktcwpijmabjl")
    public suspend fun viewName(`value`: Output<String>) {
        this.viewName = value
    }

    /**
     * @param value View definition.
     */
    @JvmName("jjeppgawbugibxib")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value Localized display name for the view.
     */
    @JvmName("qnwndkxwdqkxamac")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display name for the view.
     */
    @JvmName("duvpphopqyigynjx")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("jahfvfprtgsdbtxq")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yrkboyfqavblwhdm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value the user ID.
     */
    @JvmName("qtsmuexddsyvdmmh")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    /**
     * @param value The name of the view.
     */
    @JvmName("ifvfecwoikomlgao")
    public suspend fun viewName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewName = mapped
    }

    internal fun build(): ViewArgs = ViewArgs(
        definition = definition,
        displayName = displayName,
        hubName = hubName,
        resourceGroupName = resourceGroupName,
        userId = userId,
        viewName = viewName,
    )
}
