@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The connector mapping properties.
 * @property availability The availability of mapping property.
 * @property completeOperation The operation after import is done.
 * @property errorManagement The error management setting for the mapping.
 * @property fileFilter The file filter for the mapping.
 * @property folderPath The folder path for the mapping.
 * @property format The format of mapping property.
 * @property hasHeader If the file contains a header or not.
 * @property structure Ingestion mapping information at property level.
 */
public data class ConnectorMappingPropertiesArgs(
    public val availability: Output<ConnectorMappingAvailabilityArgs>,
    public val completeOperation: Output<ConnectorMappingCompleteOperationArgs>,
    public val errorManagement: Output<ConnectorMappingErrorManagementArgs>,
    public val fileFilter: Output<String>? = null,
    public val folderPath: Output<String>? = null,
    public val format: Output<ConnectorMappingFormatArgs>,
    public val hasHeader: Output<Boolean>? = null,
    public val structure: Output<List<ConnectorMappingStructureArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingPropertiesArgs =
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingPropertiesArgs.builder()
            .availability(availability.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .completeOperation(completeOperation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .errorManagement(errorManagement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileFilter(fileFilter?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .format(format.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hasHeader(hasHeader?.applyValue({ args0 -> args0 }))
            .structure(
                structure.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorMappingPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectorMappingPropertiesArgsBuilder internal constructor() {
    private var availability: Output<ConnectorMappingAvailabilityArgs>? = null

    private var completeOperation: Output<ConnectorMappingCompleteOperationArgs>? = null

    private var errorManagement: Output<ConnectorMappingErrorManagementArgs>? = null

    private var fileFilter: Output<String>? = null

    private var folderPath: Output<String>? = null

    private var format: Output<ConnectorMappingFormatArgs>? = null

    private var hasHeader: Output<Boolean>? = null

    private var structure: Output<List<ConnectorMappingStructureArgs>>? = null

    /**
     * @param value The availability of mapping property.
     */
    @JvmName("wvpyjmsyemacgfnu")
    public suspend fun availability(`value`: Output<ConnectorMappingAvailabilityArgs>) {
        this.availability = value
    }

    /**
     * @param value The operation after import is done.
     */
    @JvmName("rpdumbpvyeauoiij")
    public suspend fun completeOperation(`value`: Output<ConnectorMappingCompleteOperationArgs>) {
        this.completeOperation = value
    }

    /**
     * @param value The error management setting for the mapping.
     */
    @JvmName("lsuxukfmgphictmf")
    public suspend fun errorManagement(`value`: Output<ConnectorMappingErrorManagementArgs>) {
        this.errorManagement = value
    }

    /**
     * @param value The file filter for the mapping.
     */
    @JvmName("emkbpgbrdokkdnqs")
    public suspend fun fileFilter(`value`: Output<String>) {
        this.fileFilter = value
    }

    /**
     * @param value The folder path for the mapping.
     */
    @JvmName("qvvaptagqmwpuhlc")
    public suspend fun folderPath(`value`: Output<String>) {
        this.folderPath = value
    }

    /**
     * @param value The format of mapping property.
     */
    @JvmName("qhyxdmgjtinrmhrw")
    public suspend fun format(`value`: Output<ConnectorMappingFormatArgs>) {
        this.format = value
    }

    /**
     * @param value If the file contains a header or not.
     */
    @JvmName("onjftfabpoqtvdte")
    public suspend fun hasHeader(`value`: Output<Boolean>) {
        this.hasHeader = value
    }

    /**
     * @param value Ingestion mapping information at property level.
     */
    @JvmName("yawsebktvnmnelmd")
    public suspend fun structure(`value`: Output<List<ConnectorMappingStructureArgs>>) {
        this.structure = value
    }

    @JvmName("tcytmqtqrbnakcax")
    public suspend fun structure(vararg values: Output<ConnectorMappingStructureArgs>) {
        this.structure = Output.all(values.asList())
    }

    /**
     * @param values Ingestion mapping information at property level.
     */
    @JvmName("ftvnnkqhxneiirsp")
    public suspend fun structure(values: List<Output<ConnectorMappingStructureArgs>>) {
        this.structure = Output.all(values)
    }

    /**
     * @param value The availability of mapping property.
     */
    @JvmName("dbvtoihdtorgoold")
    public suspend fun availability(`value`: ConnectorMappingAvailabilityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availability = mapped
    }

    /**
     * @param argument The availability of mapping property.
     */
    @JvmName("mxbfwgjumlbsysyb")
    public suspend
    fun availability(argument: suspend ConnectorMappingAvailabilityArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorMappingAvailabilityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.availability = mapped
    }

    /**
     * @param value The operation after import is done.
     */
    @JvmName("qpeggsysgtebrvlw")
    public suspend fun completeOperation(`value`: ConnectorMappingCompleteOperationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.completeOperation = mapped
    }

    /**
     * @param argument The operation after import is done.
     */
    @JvmName("awbvpssbrqdgytpk")
    public suspend
    fun completeOperation(argument: suspend ConnectorMappingCompleteOperationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorMappingCompleteOperationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.completeOperation = mapped
    }

    /**
     * @param value The error management setting for the mapping.
     */
    @JvmName("kblxybjvoghkrwhi")
    public suspend fun errorManagement(`value`: ConnectorMappingErrorManagementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorManagement = mapped
    }

    /**
     * @param argument The error management setting for the mapping.
     */
    @JvmName("ayhibhffcswksvvv")
    public suspend
    fun errorManagement(argument: suspend ConnectorMappingErrorManagementArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorMappingErrorManagementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorManagement = mapped
    }

    /**
     * @param value The file filter for the mapping.
     */
    @JvmName("foqdehnepvstactc")
    public suspend fun fileFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFilter = mapped
    }

    /**
     * @param value The folder path for the mapping.
     */
    @JvmName("fqmwjhirheepueok")
    public suspend fun folderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value The format of mapping property.
     */
    @JvmName("bwfwvhxxudrnsfxb")
    public suspend fun format(`value`: ConnectorMappingFormatArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param argument The format of mapping property.
     */
    @JvmName("hqqfgohkbcfjuwtu")
    public suspend fun format(argument: suspend ConnectorMappingFormatArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorMappingFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.format = mapped
    }

    /**
     * @param value If the file contains a header or not.
     */
    @JvmName("xiyhvxhafpcwuxar")
    public suspend fun hasHeader(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasHeader = mapped
    }

    /**
     * @param value Ingestion mapping information at property level.
     */
    @JvmName("dssspcadrsndncab")
    public suspend fun structure(`value`: List<ConnectorMappingStructureArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param argument Ingestion mapping information at property level.
     */
    @JvmName("gecorsioufyjpbpg")
    public suspend
    fun structure(argument: List<suspend ConnectorMappingStructureArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectorMappingStructureArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.structure = mapped
    }

    /**
     * @param argument Ingestion mapping information at property level.
     */
    @JvmName("xqwinpreedcmjpgi")
    public suspend fun structure(
        vararg
        argument: suspend ConnectorMappingStructureArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectorMappingStructureArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.structure = mapped
    }

    /**
     * @param argument Ingestion mapping information at property level.
     */
    @JvmName("xvfeuxuthcfwqtvk")
    public suspend fun structure(argument: suspend ConnectorMappingStructureArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectorMappingStructureArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.structure = mapped
    }

    /**
     * @param values Ingestion mapping information at property level.
     */
    @JvmName("knkxutsmlmegrbly")
    public suspend fun structure(vararg values: ConnectorMappingStructureArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    internal fun build(): ConnectorMappingPropertiesArgs = ConnectorMappingPropertiesArgs(
        availability = availability ?: throw PulumiNullFieldException("availability"),
        completeOperation = completeOperation ?: throw PulumiNullFieldException("completeOperation"),
        errorManagement = errorManagement ?: throw PulumiNullFieldException("errorManagement"),
        fileFilter = fileFilter,
        folderPath = folderPath,
        format = format ?: throw PulumiNullFieldException("format"),
        hasHeader = hasHeader,
        structure = structure ?: throw PulumiNullFieldException("structure"),
    )
}
