@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectorName The name of the connector.
 * @property hubName The name of the hub.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetConnectorPlainArgs(
    public val connectorName: String,
    public val hubName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetConnectorPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetConnectorPlainArgs.builder()
            .connectorName(connectorName.let({ args0 -> args0 }))
            .hubName(hubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorPlainArgsBuilder internal constructor() {
    private var connectorName: String? = null

    private var hubName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the connector.
     */
    @JvmName("tuphdgyxsxyepvsc")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("omktoogunlxagdhd")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("llroxwkxfxnkldsh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectorPlainArgs = GetConnectorPlainArgs(
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
