@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property linkName The name of the link.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLinkPlainArgs(
    public val hubName: String,
    public val linkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetLinkPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetLinkPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .linkName(linkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkPlainArgs].
 */
@PulumiTagMarker
public class GetLinkPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var linkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("yniwxxvkydbxgjau")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the link.
     */
    @JvmName("agstwccpdbwvxagq")
    public suspend fun linkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bvbhgkkqyjvtqttd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLinkPlainArgs = GetLinkPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        linkName = linkName ?: throw PulumiNullFieldException("linkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
