@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetPredictionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property predictionName The name of the Prediction.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPredictionPlainArgs(
    public val hubName: String,
    public val predictionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetPredictionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetPredictionPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetPredictionPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .predictionName(predictionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPredictionPlainArgs].
 */
@PulumiTagMarker
public class GetPredictionPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var predictionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("uhlsnumtryhsfkqp")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the Prediction.
     */
    @JvmName("uolanybsrsrbiueo")
    public suspend fun predictionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.predictionName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tgcwtfehbtieudse")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPredictionPlainArgs = GetPredictionPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        predictionName = predictionName ?: throw PulumiNullFieldException("predictionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
