@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetRelationshipLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property relationshipLinkName The name of the relationship link.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetRelationshipLinkPlainArgs(
    public val hubName: String,
    public val relationshipLinkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetRelationshipLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetRelationshipLinkPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetRelationshipLinkPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .relationshipLinkName(relationshipLinkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRelationshipLinkPlainArgs].
 */
@PulumiTagMarker
public class GetRelationshipLinkPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var relationshipLinkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("ekoqpnpydglgvsun")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the relationship link.
     */
    @JvmName("hwsxjcuixmwijviu")
    public suspend fun relationshipLinkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relationshipLinkName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fukwkegkyqeidkti")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRelationshipLinkPlainArgs = GetRelationshipLinkPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        relationshipLinkName = relationshipLinkName ?: throw
            PulumiNullFieldException("relationshipLinkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
