@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.HubBillingInfoFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hub billing info.
 * @property maxUnits The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
 * @property minUnits The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
 * @property skuName The sku name.
 */
public data class HubBillingInfoFormatArgs(
    public val maxUnits: Output<Int>? = null,
    public val minUnits: Output<Int>? = null,
    public val skuName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.HubBillingInfoFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.HubBillingInfoFormatArgs =
        com.pulumi.azurenative.customerinsights.inputs.HubBillingInfoFormatArgs.builder()
            .maxUnits(maxUnits?.applyValue({ args0 -> args0 }))
            .minUnits(minUnits?.applyValue({ args0 -> args0 }))
            .skuName(skuName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubBillingInfoFormatArgs].
 */
@PulumiTagMarker
public class HubBillingInfoFormatArgsBuilder internal constructor() {
    private var maxUnits: Output<Int>? = null

    private var minUnits: Output<Int>? = null

    private var skuName: Output<String>? = null

    /**
     * @param value The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
     */
    @JvmName("dsvavimgcrlggvfb")
    public suspend fun maxUnits(`value`: Output<Int>) {
        this.maxUnits = value
    }

    /**
     * @param value The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
     */
    @JvmName("swikuutwyysheewb")
    public suspend fun minUnits(`value`: Output<Int>) {
        this.minUnits = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("jygnsigisohiguir")
    public suspend fun skuName(`value`: Output<String>) {
        this.skuName = value
    }

    /**
     * @param value The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
     */
    @JvmName("hqlbjoaxlpveidkj")
    public suspend fun maxUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnits = mapped
    }

    /**
     * @param value The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
     */
    @JvmName("oxpjmycriuxvpnho")
    public suspend fun minUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minUnits = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("dcpqfvixnibpdilh")
    public suspend fun skuName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    internal fun build(): HubBillingInfoFormatArgs = HubBillingInfoFormatArgs(
        maxUnits = maxUnits,
        minUnits = minUnits,
        skuName = skuName,
    )
}
