@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.KpiExtractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The KPI extract.
 * @property expression The expression.
 * @property extractName KPI extract name.
 */
public data class KpiExtractArgs(
    public val expression: Output<String>,
    public val extractName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.KpiExtractArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.KpiExtractArgs =
        com.pulumi.azurenative.customerinsights.inputs.KpiExtractArgs.builder()
            .expression(expression.applyValue({ args0 -> args0 }))
            .extractName(extractName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KpiExtractArgs].
 */
@PulumiTagMarker
public class KpiExtractArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var extractName: Output<String>? = null

    /**
     * @param value The expression.
     */
    @JvmName("qrrohdeodusqsrkf")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value KPI extract name.
     */
    @JvmName("irhltmdddmeodmsx")
    public suspend fun extractName(`value`: Output<String>) {
        this.extractName = value
    }

    /**
     * @param value The expression.
     */
    @JvmName("foxfveqfvmwgjdyo")
    public suspend fun expression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value KPI extract name.
     */
    @JvmName("jybatwklyglcjwhs")
    public suspend fun extractName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extractName = mapped
    }

    internal fun build(): KpiExtractArgs = KpiExtractArgs(
        expression = expression ?: throw PulumiNullFieldException("expression"),
        extractName = extractName ?: throw PulumiNullFieldException("extractName"),
    )
}
