@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ParticipantProfilePropertyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The participant profile property reference.
 * @property interactionPropertyName The source interaction property that maps to the target profile property.
 * @property profilePropertyName The target profile property that maps to the source interaction property.
 */
public data class ParticipantProfilePropertyReferenceArgs(
    public val interactionPropertyName: Output<String>,
    public val profilePropertyName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ParticipantProfilePropertyReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.ParticipantProfilePropertyReferenceArgs =
        com.pulumi.azurenative.customerinsights.inputs.ParticipantProfilePropertyReferenceArgs.builder()
            .interactionPropertyName(interactionPropertyName.applyValue({ args0 -> args0 }))
            .profilePropertyName(profilePropertyName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParticipantProfilePropertyReferenceArgs].
 */
@PulumiTagMarker
public class ParticipantProfilePropertyReferenceArgsBuilder internal constructor() {
    private var interactionPropertyName: Output<String>? = null

    private var profilePropertyName: Output<String>? = null

    /**
     * @param value The source interaction property that maps to the target profile property.
     */
    @JvmName("lowafystoxioypyn")
    public suspend fun interactionPropertyName(`value`: Output<String>) {
        this.interactionPropertyName = value
    }

    /**
     * @param value The target profile property that maps to the source interaction property.
     */
    @JvmName("wsybjjuohghtkmkr")
    public suspend fun profilePropertyName(`value`: Output<String>) {
        this.profilePropertyName = value
    }

    /**
     * @param value The source interaction property that maps to the target profile property.
     */
    @JvmName("vkyhggpgiiojqjts")
    public suspend fun interactionPropertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interactionPropertyName = mapped
    }

    /**
     * @param value The target profile property that maps to the source interaction property.
     */
    @JvmName("yrjsolxrygjctwbb")
    public suspend fun profilePropertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profilePropertyName = mapped
    }

    internal fun build(): ParticipantProfilePropertyReferenceArgs =
        ParticipantProfilePropertyReferenceArgs(
            interactionPropertyName = interactionPropertyName ?: throw
                PulumiNullFieldException("interactionPropertyName"),
            profilePropertyName = profilePropertyName ?: throw PulumiNullFieldException("profilePropertyName"),
        )
}
