@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ParticipantPropertyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The participant property reference.
 * @property sourcePropertyName The source property that maps to the target property.
 * @property targetPropertyName The target property that maps to the source property.
 */
public data class ParticipantPropertyReferenceArgs(
    public val sourcePropertyName: Output<String>,
    public val targetPropertyName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ParticipantPropertyReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.ParticipantPropertyReferenceArgs =
        com.pulumi.azurenative.customerinsights.inputs.ParticipantPropertyReferenceArgs.builder()
            .sourcePropertyName(sourcePropertyName.applyValue({ args0 -> args0 }))
            .targetPropertyName(targetPropertyName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParticipantPropertyReferenceArgs].
 */
@PulumiTagMarker
public class ParticipantPropertyReferenceArgsBuilder internal constructor() {
    private var sourcePropertyName: Output<String>? = null

    private var targetPropertyName: Output<String>? = null

    /**
     * @param value The source property that maps to the target property.
     */
    @JvmName("ohsimlcsxyuvsrfd")
    public suspend fun sourcePropertyName(`value`: Output<String>) {
        this.sourcePropertyName = value
    }

    /**
     * @param value The target property that maps to the source property.
     */
    @JvmName("btpjugbfvcfjcasb")
    public suspend fun targetPropertyName(`value`: Output<String>) {
        this.targetPropertyName = value
    }

    /**
     * @param value The source property that maps to the target property.
     */
    @JvmName("wvsviaegdafqqmpt")
    public suspend fun sourcePropertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePropertyName = mapped
    }

    /**
     * @param value The target property that maps to the source property.
     */
    @JvmName("wvolrofqntjcgkte")
    public suspend fun targetPropertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPropertyName = mapped
    }

    internal fun build(): ParticipantPropertyReferenceArgs = ParticipantPropertyReferenceArgs(
        sourcePropertyName = sourcePropertyName ?: throw PulumiNullFieldException("sourcePropertyName"),
        targetPropertyName = targetPropertyName ?: throw PulumiNullFieldException("targetPropertyName"),
    )
}
