@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeFieldMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Map a field of profile to its corresponding StrongId in Related Profile.
 * @property profileFieldName Specifies the fieldName in profile.
 * @property relatedProfileKeyProperty Specifies the KeyProperty (from StrongId) of the related profile.
 */
public data class RelationshipTypeFieldMappingArgs(
    public val profileFieldName: Output<String>,
    public val relatedProfileKeyProperty: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeFieldMappingArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeFieldMappingArgs =
        com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeFieldMappingArgs.builder()
            .profileFieldName(profileFieldName.applyValue({ args0 -> args0 }))
            .relatedProfileKeyProperty(relatedProfileKeyProperty.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RelationshipTypeFieldMappingArgs].
 */
@PulumiTagMarker
public class RelationshipTypeFieldMappingArgsBuilder internal constructor() {
    private var profileFieldName: Output<String>? = null

    private var relatedProfileKeyProperty: Output<String>? = null

    /**
     * @param value Specifies the fieldName in profile.
     */
    @JvmName("gwhvexjhqfxhuadq")
    public suspend fun profileFieldName(`value`: Output<String>) {
        this.profileFieldName = value
    }

    /**
     * @param value Specifies the KeyProperty (from StrongId) of the related profile.
     */
    @JvmName("eybvgrcdqdtfiqwp")
    public suspend fun relatedProfileKeyProperty(`value`: Output<String>) {
        this.relatedProfileKeyProperty = value
    }

    /**
     * @param value Specifies the fieldName in profile.
     */
    @JvmName("lkhooobukucjphwa")
    public suspend fun profileFieldName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileFieldName = mapped
    }

    /**
     * @param value Specifies the KeyProperty (from StrongId) of the related profile.
     */
    @JvmName("wcnfptpjlfyuivae")
    public suspend fun relatedProfileKeyProperty(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedProfileKeyProperty = mapped
    }

    internal fun build(): RelationshipTypeFieldMappingArgs = RelationshipTypeFieldMappingArgs(
        profileFieldName = profileFieldName ?: throw PulumiNullFieldException("profileFieldName"),
        relatedProfileKeyProperty = relatedProfileKeyProperty ?: throw
            PulumiNullFieldException("relatedProfileKeyProperty"),
    )
}
