@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Maps fields in Profile to their corresponding StrongIds in Related Profile.
 * @property fieldMappings Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
 */
public data class RelationshipTypeMappingArgs(
    public val fieldMappings: Output<List<RelationshipTypeFieldMappingArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeMappingArgs =
        com.pulumi.azurenative.customerinsights.inputs.RelationshipTypeMappingArgs.builder()
            .fieldMappings(
                fieldMappings.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RelationshipTypeMappingArgs].
 */
@PulumiTagMarker
public class RelationshipTypeMappingArgsBuilder internal constructor() {
    private var fieldMappings: Output<List<RelationshipTypeFieldMappingArgs>>? = null

    /**
     * @param value Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("hoxrkqitxedkpeeb")
    public suspend fun fieldMappings(`value`: Output<List<RelationshipTypeFieldMappingArgs>>) {
        this.fieldMappings = value
    }

    @JvmName("rkqqbpyfyoyffwgk")
    public suspend fun fieldMappings(vararg values: Output<RelationshipTypeFieldMappingArgs>) {
        this.fieldMappings = Output.all(values.asList())
    }

    /**
     * @param values Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("ewwsqkqesrhhthrc")
    public suspend fun fieldMappings(values: List<Output<RelationshipTypeFieldMappingArgs>>) {
        this.fieldMappings = Output.all(values)
    }

    /**
     * @param value Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("rdvotssqjsjhrsyf")
    public suspend fun fieldMappings(`value`: List<RelationshipTypeFieldMappingArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldMappings = mapped
    }

    /**
     * @param argument Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("knbdwfjcexeblreg")
    public suspend
    fun fieldMappings(argument: List<suspend RelationshipTypeFieldMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RelationshipTypeFieldMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldMappings = mapped
    }

    /**
     * @param argument Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("nyqfnlxoxkbnuvit")
    public suspend fun fieldMappings(
        vararg
        argument: suspend RelationshipTypeFieldMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RelationshipTypeFieldMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldMappings = mapped
    }

    /**
     * @param argument Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("plgyotjxyrecxwqg")
    public suspend
    fun fieldMappings(argument: suspend RelationshipTypeFieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RelationshipTypeFieldMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fieldMappings = mapped
    }

    /**
     * @param values Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
     */
    @JvmName("hvjfrmssftmiohmv")
    public suspend fun fieldMappings(vararg values: RelationshipTypeFieldMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldMappings = mapped
    }

    internal fun build(): RelationshipTypeMappingArgs = RelationshipTypeMappingArgs(
        fieldMappings = fieldMappings ?: throw PulumiNullFieldException("fieldMappings"),
    )
}
