@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ResourceSetDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The resource set description.
 * @property elements The elements included in the set.
 * @property exceptions The elements that are not included in the set, in case elements contains '*' indicating 'all'.
 */
public data class ResourceSetDescriptionArgs(
    public val elements: Output<List<String>>? = null,
    public val exceptions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ResourceSetDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.ResourceSetDescriptionArgs =
        com.pulumi.azurenative.customerinsights.inputs.ResourceSetDescriptionArgs.builder()
            .elements(elements?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exceptions(exceptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceSetDescriptionArgs].
 */
@PulumiTagMarker
public class ResourceSetDescriptionArgsBuilder internal constructor() {
    private var elements: Output<List<String>>? = null

    private var exceptions: Output<List<String>>? = null

    /**
     * @param value The elements included in the set.
     */
    @JvmName("gkxybmscpuvgkllw")
    public suspend fun elements(`value`: Output<List<String>>) {
        this.elements = value
    }

    @JvmName("airmfvuldrgsqncn")
    public suspend fun elements(vararg values: Output<String>) {
        this.elements = Output.all(values.asList())
    }

    /**
     * @param values The elements included in the set.
     */
    @JvmName("tjbubxwqawnotfmj")
    public suspend fun elements(values: List<Output<String>>) {
        this.elements = Output.all(values)
    }

    /**
     * @param value The elements that are not included in the set, in case elements contains '*' indicating 'all'.
     */
    @JvmName("frmrtdwncuekcerj")
    public suspend fun exceptions(`value`: Output<List<String>>) {
        this.exceptions = value
    }

    @JvmName("sitsoptkhqtptbhn")
    public suspend fun exceptions(vararg values: Output<String>) {
        this.exceptions = Output.all(values.asList())
    }

    /**
     * @param values The elements that are not included in the set, in case elements contains '*' indicating 'all'.
     */
    @JvmName("gebpeelsnbodndhd")
    public suspend fun exceptions(values: List<Output<String>>) {
        this.exceptions = Output.all(values)
    }

    /**
     * @param value The elements included in the set.
     */
    @JvmName("ynlcjaplydwtbgwf")
    public suspend fun elements(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elements = mapped
    }

    /**
     * @param values The elements included in the set.
     */
    @JvmName("cmmysgoahvnrfpkd")
    public suspend fun elements(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elements = mapped
    }

    /**
     * @param value The elements that are not included in the set, in case elements contains '*' indicating 'all'.
     */
    @JvmName("umvgiffwsmpnrmkt")
    public suspend fun exceptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exceptions = mapped
    }

    /**
     * @param values The elements that are not included in the set, in case elements contains '*' indicating 'all'.
     */
    @JvmName("njislvcidvcpwlht")
    public suspend fun exceptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exceptions = mapped
    }

    internal fun build(): ResourceSetDescriptionArgs = ResourceSetDescriptionArgs(
        elements = elements,
        exceptions = exceptions,
    )
}
