@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The connector mapping resource format.
 * @property connectorMappingName The connector mapping name
 * @property connectorName The connector name.
 * @property connectorType Type of connector.
 * @property created The created time.
 * @property dataFormatId The DataFormat ID.
 * @property description The description of the connector mapping.
 * @property displayName Display name for the connector mapping.
 * @property entityType Defines which entity type the file should map to.
 * @property entityTypeName The mapping entity name.
 * @property id Resource ID.
 * @property lastModified The last modified time.
 * @property mappingProperties The properties of the mapping.
 * @property name Resource name.
 * @property nextRunTime The next run time based on customer's settings.
 * @property runId The RunId.
 * @property state State of connector mapping.
 * @property tenantId The hub name.
 * @property type Resource type.
 */
public data class GetConnectorMappingResult(
    public val connectorMappingName: String,
    public val connectorName: String,
    public val connectorType: String? = null,
    public val created: String,
    public val dataFormatId: String,
    public val description: String? = null,
    public val displayName: String? = null,
    public val entityType: String,
    public val entityTypeName: String,
    public val id: String,
    public val lastModified: String,
    public val mappingProperties: ConnectorMappingPropertiesResponse,
    public val name: String,
    public val nextRunTime: String,
    public val runId: String,
    public val state: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetConnectorMappingResult):
            GetConnectorMappingResult = GetConnectorMappingResult(
            connectorMappingName = javaType.connectorMappingName(),
            connectorName = javaType.connectorName(),
            connectorType = javaType.connectorType().map({ args0 -> args0 }).orElse(null),
            created = javaType.created(),
            dataFormatId = javaType.dataFormatId(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            entityType = javaType.entityType(),
            entityTypeName = javaType.entityTypeName(),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            mappingProperties = javaType.mappingProperties().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingPropertiesResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            nextRunTime = javaType.nextRunTime(),
            runId = javaType.runId(),
            state = javaType.state(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
