@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The connector resource format.
 * @property connectorId ID of the connector.
 * @property connectorName Name of the connector.
 * @property connectorProperties The connector properties.
 * @property connectorType Type of connector.
 * @property created The created time.
 * @property description Description of the connector.
 * @property displayName Display name of the connector.
 * @property id Resource ID.
 * @property isInternal If this is an internal connector.
 * @property lastModified The last modified time.
 * @property name Resource name.
 * @property state State of connector.
 * @property tenantId The hub name.
 * @property type Resource type.
 */
public data class GetConnectorResult(
    public val connectorId: Int,
    public val connectorName: String? = null,
    public val connectorProperties: Map<String, Any>,
    public val connectorType: String,
    public val created: String,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val isInternal: Boolean? = null,
    public val lastModified: String,
    public val name: String,
    public val state: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetConnectorResult):
            GetConnectorResult = GetConnectorResult(
            connectorId = javaType.connectorId(),
            connectorName = javaType.connectorName().map({ args0 -> args0 }).orElse(null),
            connectorProperties = javaType.connectorProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            connectorType = javaType.connectorType(),
            created = javaType.created(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isInternal = javaType.isInternal().map({ args0 -> args0 }).orElse(null),
            lastModified = javaType.lastModified(),
            name = javaType.name(),
            state = javaType.state(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
