@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The image definition.
 * @property contentUrl Content URL for the image blob.
 * @property imageExists Whether image exists already.
 * @property relativePath Relative path of the image.
 */
public data class GetImageUploadUrlForDataResult(
    public val contentUrl: String? = null,
    public val imageExists: Boolean? = null,
    public val relativePath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetImageUploadUrlForDataResult):
            GetImageUploadUrlForDataResult = GetImageUploadUrlForDataResult(
            contentUrl = javaType.contentUrl().map({ args0 -> args0 }).orElse(null),
            imageExists = javaType.imageExists().map({ args0 -> args0 }).orElse(null),
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
