@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Maps fields in Profile to their corresponding StrongIds in Related Profile.
 * @property fieldMappings Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
 */
public data class RelationshipTypeMappingResponse(
    public val fieldMappings: List<RelationshipTypeFieldMappingResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.RelationshipTypeMappingResponse):
            RelationshipTypeMappingResponse = RelationshipTypeMappingResponse(
            fieldMappings = javaType.fieldMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipTypeFieldMappingResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
