@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin

import com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPActionRouteDefinitionResponse
import com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPResourceTypeRouteDefinitionResponse
import com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPValidationsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPActionRouteDefinitionResponse.Companion.toKotlin as customRPActionRouteDefinitionResponseToKotlin
import com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPResourceTypeRouteDefinitionResponse.Companion.toKotlin as customRPResourceTypeRouteDefinitionResponseToKotlin
import com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPValidationsResponse.Companion.toKotlin as customRPValidationsResponseToKotlin

/**
 * Builder for [CustomResourceProvider].
 */
@PulumiTagMarker
public class CustomResourceProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomResourceProviderArgs = CustomResourceProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomResourceProviderArgsBuilder.() -> Unit) {
        val builder = CustomResourceProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomResourceProvider {
        val builtJavaResource =
            com.pulumi.azurenative.customproviders.CustomResourceProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomResourceProvider(builtJavaResource)
    }
}

/**
 * A manifest file that defines the custom resource provider resources.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### Create or update the custom resource provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customResourceProvider = new AzureNative.CustomProviders.CustomResourceProvider("customResourceProvider", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.CustomProviders.Inputs.CustomRPActionRouteDefinitionArgs
 *             {
 *                 Endpoint = "https://mytestendpoint/",
 *                 Name = "TestAction",
 *                 RoutingType = "Proxy",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "testRG",
 *         ResourceProviderName = "newrp",
 *         ResourceTypes = new[]
 *         {
 *             new AzureNative.CustomProviders.Inputs.CustomRPResourceTypeRouteDefinitionArgs
 *             {
 *                 Endpoint = "https://mytestendpoint2/",
 *                 Name = "TestResource",
 *                 RoutingType = "Proxy,Cache",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customproviders/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customproviders.NewCustomResourceProvider(ctx, "customResourceProvider", &customproviders.CustomResourceProviderArgs{
 * 			Actions: []customproviders.CustomRPActionRouteDefinitionArgs{
 * 				{
 * 					Endpoint:    pulumi.String("https://mytestendpoint/"),
 * 					Name:        pulumi.String("TestAction"),
 * 					RoutingType: pulumi.String("Proxy"),
 * 				},
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			ResourceGroupName:    pulumi.String("testRG"),
 * 			ResourceProviderName: pulumi.String("newrp"),
 * 			ResourceTypes: []customproviders.CustomRPResourceTypeRouteDefinitionArgs{
 * 				{
 * 					Endpoint:    pulumi.String("https://mytestendpoint2/"),
 * 					Name:        pulumi.String("TestResource"),
 * 					RoutingType: pulumi.String("Proxy,Cache"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customproviders.CustomResourceProvider;
 * import com.pulumi.azurenative.customproviders.CustomResourceProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customResourceProvider = new CustomResourceProvider("customResourceProvider", CustomResourceProviderArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("endpoint", "https://mytestendpoint/"),
 *                 Map.entry("name", "TestAction"),
 *                 Map.entry("routingType", "Proxy")
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("testRG")
 *             .resourceProviderName("newrp")
 *             .resourceTypes(Map.ofEntries(
 *                 Map.entry("endpoint", "https://mytestendpoint2/"),
 *                 Map.entry("name", "TestResource"),
 *                 Map.entry("routingType", "Proxy,Cache")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customproviders:CustomResourceProvider newrp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}
 * ```
 */
public class CustomResourceProvider internal constructor(
    override val javaResource: com.pulumi.azurenative.customproviders.CustomResourceProvider,
) : KotlinCustomResource(javaResource, CustomResourceProviderMapper) {
    /**
     * A list of actions that the custom resource provider implements.
     */
    public val actions: Output<List<CustomRPActionRouteDefinitionResponse>>?
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        customRPActionRouteDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource provider.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A list of resource types that the custom resource provider implements.
     */
    public val resourceTypes: Output<List<CustomRPResourceTypeRouteDefinitionResponse>>?
        get() = javaResource.resourceTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        customRPResourceTypeRouteDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of validations to run on the custom resource provider's requests.
     */
    public val validations: Output<List<CustomRPValidationsResponse>>?
        get() = javaResource.validations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> customRPValidationsResponseToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object CustomResourceProviderMapper : ResourceMapper<CustomResourceProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customproviders.CustomResourceProvider::class == javaResource::class

    override fun map(javaResource: Resource): CustomResourceProvider =
        CustomResourceProvider(
            javaResource as
                com.pulumi.azurenative.customproviders.CustomResourceProvider,
        )
}

/**
 * @see [CustomResourceProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomResourceProvider].
 */
public suspend fun customResourceProvider(
    name: String,
    block: suspend CustomResourceProviderResourceBuilder.() -> Unit,
): CustomResourceProvider {
    val builder = CustomResourceProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomResourceProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customResourceProvider(name: String): CustomResourceProvider {
    val builder = CustomResourceProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
