@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.inputs

import com.pulumi.azurenative.customproviders.inputs.GetAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property associationName The name of the association.
 * @property scope The scope of the association.
 */
public data class GetAssociationPlainArgs(
    public val associationName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.customproviders.inputs.GetAssociationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customproviders.inputs.GetAssociationPlainArgs =
        com.pulumi.azurenative.customproviders.inputs.GetAssociationPlainArgs.builder()
            .associationName(associationName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetAssociationPlainArgsBuilder internal constructor() {
    private var associationName: String? = null

    private var scope: String? = null

    /**
     * @param value The name of the association.
     */
    @JvmName("xqxfoxkfwifnndor")
    public suspend fun associationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.associationName = mapped
    }

    /**
     * @param value The scope of the association.
     */
    @JvmName("hxwxlprqeinkoenn")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetAssociationPlainArgs = GetAssociationPlainArgs(
        associationName = associationName ?: throw PulumiNullFieldException("associationName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
