@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.inputs

import com.pulumi.azurenative.customproviders.inputs.GetCustomResourceProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceProviderName The name of the resource provider.
 */
public data class GetCustomResourceProviderPlainArgs(
    public val resourceGroupName: String,
    public val resourceProviderName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.customproviders.inputs.GetCustomResourceProviderPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.customproviders.inputs.GetCustomResourceProviderPlainArgs =
        com.pulumi.azurenative.customproviders.inputs.GetCustomResourceProviderPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceProviderName(resourceProviderName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomResourceProviderPlainArgs].
 */
@PulumiTagMarker
public class GetCustomResourceProviderPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceProviderName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("spepwepbvasymbgv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource provider.
     */
    @JvmName("ecindcheyolyyjrd")
    public suspend fun resourceProviderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceProviderName = mapped
    }

    internal fun build(): GetCustomResourceProviderPlainArgs = GetCustomResourceProviderPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceProviderName = resourceProviderName ?: throw
            PulumiNullFieldException("resourceProviderName"),
    )
}
