@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines secondary layer of software-based encryption enablement.
 */
public enum class DoubleEncryption(
    public val javaValue: com.pulumi.azurenative.databox.enums.DoubleEncryption,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.DoubleEncryption> {
    /**
     * Software-based encryption is enabled.
     */
    Enabled(com.pulumi.azurenative.databox.enums.DoubleEncryption.Enabled),

    /**
     * Software-based encryption is disabled.
     */
    Disabled(com.pulumi.azurenative.databox.enums.DoubleEncryption.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.DoubleEncryption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.DoubleEncryption):
            DoubleEncryption = DoubleEncryption.values().first { it.javaValue == javaType }
    }
}
