@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the stage.
 */
public enum class NotificationStageName(
    public val javaValue: com.pulumi.azurenative.databox.enums.NotificationStageName,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.NotificationStageName> {
    /**
     * Notification at device prepared stage.
     */
    DevicePrepared(com.pulumi.azurenative.databox.enums.NotificationStageName.DevicePrepared),

    /**
     * Notification at device dispatched stage.
     */
    Dispatched(com.pulumi.azurenative.databox.enums.NotificationStageName.Dispatched),

    /**
     * Notification at device delivered stage.
     */
    Delivered(com.pulumi.azurenative.databox.enums.NotificationStageName.Delivered),

    /**
     * Notification at device picked up from user stage.
     */
    PickedUp(com.pulumi.azurenative.databox.enums.NotificationStageName.PickedUp),

    /**
     * Notification at device received at Azure datacenter stage.
     */
    AtAzureDC(com.pulumi.azurenative.databox.enums.NotificationStageName.AtAzureDC),

    /**
     * Notification at data copy started stage.
     */
    DataCopy(com.pulumi.azurenative.databox.enums.NotificationStageName.DataCopy),

    /**
     * Notification at job created stage.
     */
    Created(com.pulumi.azurenative.databox.enums.NotificationStageName.Created),

    /**
     * Notification at shipped devices to customer stage.
     */
    ShippedToCustomer(com.pulumi.azurenative.databox.enums.NotificationStageName.ShippedToCustomer),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.NotificationStageName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.NotificationStageName):
            NotificationStageName = NotificationStageName.values().first { it.javaValue == javaType }
    }
}
