@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ContactInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contact Info.
 * @property contactName Contact name of the person.
 * @property mobile Mobile number of the contact person.
 * @property phone Phone number of the contact person.
 * @property phoneExtension Phone extension number of the contact person.
 */
public data class ContactInfoArgs(
    public val contactName: Output<String>,
    public val mobile: Output<String>? = null,
    public val phone: Output<String>,
    public val phoneExtension: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ContactInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ContactInfoArgs =
        com.pulumi.azurenative.databox.inputs.ContactInfoArgs.builder()
            .contactName(contactName.applyValue({ args0 -> args0 }))
            .mobile(mobile?.applyValue({ args0 -> args0 }))
            .phone(phone.applyValue({ args0 -> args0 }))
            .phoneExtension(phoneExtension?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactInfoArgs].
 */
@PulumiTagMarker
public class ContactInfoArgsBuilder internal constructor() {
    private var contactName: Output<String>? = null

    private var mobile: Output<String>? = null

    private var phone: Output<String>? = null

    private var phoneExtension: Output<String>? = null

    /**
     * @param value Contact name of the person.
     */
    @JvmName("aqlwpomftpehcveg")
    public suspend fun contactName(`value`: Output<String>) {
        this.contactName = value
    }

    /**
     * @param value Mobile number of the contact person.
     */
    @JvmName("ukssouttkdvkwyru")
    public suspend fun mobile(`value`: Output<String>) {
        this.mobile = value
    }

    /**
     * @param value Phone number of the contact person.
     */
    @JvmName("kidiigyutfeoaefy")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Phone extension number of the contact person.
     */
    @JvmName("abvcdslnclidvoxe")
    public suspend fun phoneExtension(`value`: Output<String>) {
        this.phoneExtension = value
    }

    /**
     * @param value Contact name of the person.
     */
    @JvmName("tbmgmfscehqtotlw")
    public suspend fun contactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactName = mapped
    }

    /**
     * @param value Mobile number of the contact person.
     */
    @JvmName("lojgfrfthdjfbnjw")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobile = mapped
    }

    /**
     * @param value Phone number of the contact person.
     */
    @JvmName("rqwgqijfgwxydyrh")
    public suspend fun phone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value Phone extension number of the contact person.
     */
    @JvmName("okqouvkxhxtkloxw")
    public suspend fun phoneExtension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneExtension = mapped
    }

    internal fun build(): ContactInfoArgs = ContactInfoArgs(
        contactName = contactName ?: throw PulumiNullFieldException("contactName"),
        mobile = mobile,
        phone = phone ?: throw PulumiNullFieldException("phone"),
        phoneExtension = phoneExtension,
    )
}
