@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.DataBoxDiskJobDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * DataBox Disk Job Details.
 * @property contactDetails Contact details for notification and shipping.
 * @property dataExportDetails Details of the data to be exported from azure.
 * @property dataImportDetails Details of the data to be imported into azure.
 * @property expectedDataSizeInTeraBytes The expected size of the data, which needs to be transferred in this job, in terabytes.
 * @property jobDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxDisk'.
 * @property keyEncryptionKey Details about which key encryption type is being used.
 * @property passkey User entered passkey for DataBox Disk job.
 * @property preferences Preferences for the order.
 * @property preferredDisks User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
 * @property reverseShippingDetails Optional Reverse Shipping details for order.
 * @property shippingAddress Shipping address of the customer.
 */
public data class DataBoxDiskJobDetailsArgs(
    public val contactDetails: Output<ContactDetailsArgs>,
    public val dataExportDetails: Output<List<DataExportDetailsArgs>>? = null,
    public val dataImportDetails: Output<List<DataImportDetailsArgs>>? = null,
    public val expectedDataSizeInTeraBytes: Output<Int>? = null,
    public val jobDetailsType: Output<String>,
    public val keyEncryptionKey: Output<KeyEncryptionKeyArgs>? = null,
    public val passkey: Output<String>? = null,
    public val preferences: Output<PreferencesArgs>? = null,
    public val preferredDisks: Output<Map<String, Int>>? = null,
    public val reverseShippingDetails: Output<ReverseShippingDetailsArgs>? = null,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.DataBoxDiskJobDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.DataBoxDiskJobDetailsArgs =
        com.pulumi.azurenative.databox.inputs.DataBoxDiskJobDetailsArgs.builder()
            .contactDetails(contactDetails.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataExportDetails(
                dataExportDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataImportDetails(
                dataImportDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .expectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes?.applyValue({ args0 -> args0 }))
            .jobDetailsType(jobDetailsType.applyValue({ args0 -> args0 }))
            .keyEncryptionKey(keyEncryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .passkey(passkey?.applyValue({ args0 -> args0 }))
            .preferences(preferences?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preferredDisks(
                preferredDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .reverseShippingDetails(
                reverseShippingDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataBoxDiskJobDetailsArgs].
 */
@PulumiTagMarker
public class DataBoxDiskJobDetailsArgsBuilder internal constructor() {
    private var contactDetails: Output<ContactDetailsArgs>? = null

    private var dataExportDetails: Output<List<DataExportDetailsArgs>>? = null

    private var dataImportDetails: Output<List<DataImportDetailsArgs>>? = null

    private var expectedDataSizeInTeraBytes: Output<Int>? = null

    private var jobDetailsType: Output<String>? = null

    private var keyEncryptionKey: Output<KeyEncryptionKeyArgs>? = null

    private var passkey: Output<String>? = null

    private var preferences: Output<PreferencesArgs>? = null

    private var preferredDisks: Output<Map<String, Int>>? = null

    private var reverseShippingDetails: Output<ReverseShippingDetailsArgs>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    /**
     * @param value Contact details for notification and shipping.
     */
    @JvmName("snebwcyigfryifcm")
    public suspend fun contactDetails(`value`: Output<ContactDetailsArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value Details of the data to be exported from azure.
     */
    @JvmName("emnybdxutdrdiehi")
    public suspend fun dataExportDetails(`value`: Output<List<DataExportDetailsArgs>>) {
        this.dataExportDetails = value
    }

    @JvmName("rmjrdpfxrelequbk")
    public suspend fun dataExportDetails(vararg values: Output<DataExportDetailsArgs>) {
        this.dataExportDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the data to be exported from azure.
     */
    @JvmName("hmcolfthemqybvan")
    public suspend fun dataExportDetails(values: List<Output<DataExportDetailsArgs>>) {
        this.dataExportDetails = Output.all(values)
    }

    /**
     * @param value Details of the data to be imported into azure.
     */
    @JvmName("kkbmywowivpxklax")
    public suspend fun dataImportDetails(`value`: Output<List<DataImportDetailsArgs>>) {
        this.dataImportDetails = value
    }

    @JvmName("fndtxwdlktmxsxhw")
    public suspend fun dataImportDetails(vararg values: Output<DataImportDetailsArgs>) {
        this.dataImportDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the data to be imported into azure.
     */
    @JvmName("pmblnaxbjmvsywox")
    public suspend fun dataImportDetails(values: List<Output<DataImportDetailsArgs>>) {
        this.dataImportDetails = Output.all(values)
    }

    /**
     * @param value The expected size of the data, which needs to be transferred in this job, in terabytes.
     */
    @JvmName("idvcfnccruqcantw")
    public suspend fun expectedDataSizeInTeraBytes(`value`: Output<Int>) {
        this.expectedDataSizeInTeraBytes = value
    }

    /**
     * @param value Indicates the type of job details.
     * Expected value is 'DataBoxDisk'.
     */
    @JvmName("jinodohkaykaiffx")
    public suspend fun jobDetailsType(`value`: Output<String>) {
        this.jobDetailsType = value
    }

    /**
     * @param value Details about which key encryption type is being used.
     */
    @JvmName("onqyypyikyrbstdx")
    public suspend fun keyEncryptionKey(`value`: Output<KeyEncryptionKeyArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value User entered passkey for DataBox Disk job.
     */
    @JvmName("mcywosujwaevutuq")
    public suspend fun passkey(`value`: Output<String>) {
        this.passkey = value
    }

    /**
     * @param value Preferences for the order.
     */
    @JvmName("ddococuiddiebnhp")
    public suspend fun preferences(`value`: Output<PreferencesArgs>) {
        this.preferences = value
    }

    /**
     * @param value User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
     */
    @JvmName("oviibrynvggqpuxb")
    public suspend fun preferredDisks(`value`: Output<Map<String, Int>>) {
        this.preferredDisks = value
    }

    /**
     * @param value Optional Reverse Shipping details for order.
     */
    @JvmName("fegmjedsjhundoyu")
    public suspend fun reverseShippingDetails(`value`: Output<ReverseShippingDetailsArgs>) {
        this.reverseShippingDetails = value
    }

    /**
     * @param value Shipping address of the customer.
     */
    @JvmName("lilumqwarioqphiq")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Contact details for notification and shipping.
     */
    @JvmName("jelpjqljjkxmydbf")
    public suspend fun contactDetails(`value`: ContactDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact details for notification and shipping.
     */
    @JvmName("mmogmmberltdnymf")
    public suspend fun contactDetails(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value Details of the data to be exported from azure.
     */
    @JvmName("ouhteqvvgsvopqeh")
    public suspend fun dataExportDetails(`value`: List<DataExportDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("nxtalwwsnstyywis")
    public suspend
    fun dataExportDetails(argument: List<suspend DataExportDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataExportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("tjqotrbmpmxkditp")
    public suspend fun dataExportDetails(
        vararg
        argument: suspend DataExportDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataExportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("pcpldflblrdgmbsf")
    public suspend fun dataExportDetails(argument: suspend DataExportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataExportDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param values Details of the data to be exported from azure.
     */
    @JvmName("lwisbxkytwnbbmhm")
    public suspend fun dataExportDetails(vararg values: DataExportDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataExportDetails = mapped
    }

    /**
     * @param value Details of the data to be imported into azure.
     */
    @JvmName("nbnxaoinityvuduv")
    public suspend fun dataImportDetails(`value`: List<DataImportDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("coupxggomffnyhhm")
    public suspend
    fun dataImportDetails(argument: List<suspend DataImportDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataImportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("hqrccnlatoehlgad")
    public suspend fun dataImportDetails(
        vararg
        argument: suspend DataImportDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataImportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("bygvurxxpwmjxdne")
    public suspend fun dataImportDetails(argument: suspend DataImportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataImportDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param values Details of the data to be imported into azure.
     */
    @JvmName("gopnnylxidqhqqfp")
    public suspend fun dataImportDetails(vararg values: DataImportDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataImportDetails = mapped
    }

    /**
     * @param value The expected size of the data, which needs to be transferred in this job, in terabytes.
     */
    @JvmName("umuxkmeobaklfdko")
    public suspend fun expectedDataSizeInTeraBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedDataSizeInTeraBytes = mapped
    }

    /**
     * @param value Indicates the type of job details.
     * Expected value is 'DataBoxDisk'.
     */
    @JvmName("acambhpbeqiwjnmt")
    public suspend fun jobDetailsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobDetailsType = mapped
    }

    /**
     * @param value Details about which key encryption type is being used.
     */
    @JvmName("pspmxxbcgwfiuaxt")
    public suspend fun keyEncryptionKey(`value`: KeyEncryptionKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Details about which key encryption type is being used.
     */
    @JvmName("bfiprlsbpscsmkuh")
    public suspend fun keyEncryptionKey(argument: suspend KeyEncryptionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyEncryptionKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    /**
     * @param value User entered passkey for DataBox Disk job.
     */
    @JvmName("stoxkpsdipbadtph")
    public suspend fun passkey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passkey = mapped
    }

    /**
     * @param value Preferences for the order.
     */
    @JvmName("bajplufjkysgihha")
    public suspend fun preferences(`value`: PreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferences = mapped
    }

    /**
     * @param argument Preferences for the order.
     */
    @JvmName("hajvdmxtknhwhqtu")
    public suspend fun preferences(argument: suspend PreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = PreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preferences = mapped
    }

    /**
     * @param value User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
     */
    @JvmName("yhtiiqluracbypkg")
    public suspend fun preferredDisks(`value`: Map<String, Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredDisks = mapped
    }

    /**
     * @param values User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
     */
    @JvmName("cgdnvtwjugbbahcx")
    public fun preferredDisks(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredDisks = mapped
    }

    /**
     * @param value Optional Reverse Shipping details for order.
     */
    @JvmName("mjjinscjcnvjvrfp")
    public suspend fun reverseShippingDetails(`value`: ReverseShippingDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reverseShippingDetails = mapped
    }

    /**
     * @param argument Optional Reverse Shipping details for order.
     */
    @JvmName("cesxkxbamybqunro")
    public suspend
    fun reverseShippingDetails(argument: suspend ReverseShippingDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ReverseShippingDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reverseShippingDetails = mapped
    }

    /**
     * @param value Shipping address of the customer.
     */
    @JvmName("dbebcluxakkgykkn")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping address of the customer.
     */
    @JvmName("qwwwahnrcevidjjw")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): DataBoxDiskJobDetailsArgs = DataBoxDiskJobDetailsArgs(
        contactDetails = contactDetails ?: throw PulumiNullFieldException("contactDetails"),
        dataExportDetails = dataExportDetails,
        dataImportDetails = dataImportDetails,
        expectedDataSizeInTeraBytes = expectedDataSizeInTeraBytes,
        jobDetailsType = jobDetailsType ?: throw PulumiNullFieldException("jobDetailsType"),
        keyEncryptionKey = keyEncryptionKey,
        passkey = passkey,
        preferences = preferences,
        preferredDisks = preferredDisks,
        reverseShippingDetails = reverseShippingDetails,
        shippingAddress = shippingAddress,
    )
}
