@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.DataImportDetailsArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.LogCollectionLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the data to be used for importing data to azure.
 * @property accountDetails Account details of the data to be transferred
 * @property logCollectionLevel Level of the logs to be collected.
 */
public data class DataImportDetailsArgs(
    public val accountDetails: Output<Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>>,
    public val logCollectionLevel: Output<Either<String, LogCollectionLevel>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.DataImportDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.DataImportDetailsArgs =
        com.pulumi.azurenative.databox.inputs.DataImportDetailsArgs.builder()
            .accountDetails(
                accountDetails.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .logCollectionLevel(
                logCollectionLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DataImportDetailsArgs].
 */
@PulumiTagMarker
public class DataImportDetailsArgsBuilder internal constructor() {
    private var accountDetails: Output<Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>>? =
        null

    private var logCollectionLevel: Output<Either<String, LogCollectionLevel>>? = null

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("eahjaeijgnjeapse")
    public suspend
    fun accountDetails(`value`: Output<Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>>) {
        this.accountDetails = value
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("qtdlhagfircgwmem")
    public suspend fun logCollectionLevel(`value`: Output<Either<String, LogCollectionLevel>>) {
        this.logCollectionLevel = value
    }

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("sahmdmcnxkxqoixn")
    public suspend
    fun accountDetails(`value`: Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountDetails = mapped
    }

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("efnjcsumkmsafjcd")
    public fun accountDetails(`value`: ManagedDiskDetailsArgs) {
        val toBeMapped = Either.ofLeft<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountDetails = mapped
    }

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("ileavocqrsovwtbr")
    public fun accountDetails(`value`: StorageAccountDetailsArgs) {
        val toBeMapped = Either.ofRight<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountDetails = mapped
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("nrgmkbgkvpyaqllo")
    public suspend fun logCollectionLevel(`value`: Either<String, LogCollectionLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logCollectionLevel = mapped
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("fbjdxflbmxkjwxni")
    public fun logCollectionLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogCollectionLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logCollectionLevel = mapped
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("dbmxcdsfkklcqdns")
    public fun logCollectionLevel(`value`: LogCollectionLevel) {
        val toBeMapped = Either.ofRight<String, LogCollectionLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logCollectionLevel = mapped
    }

    internal fun build(): DataImportDetailsArgs = DataImportDetailsArgs(
        accountDetails = accountDetails ?: throw PulumiNullFieldException("accountDetails"),
        logCollectionLevel = logCollectionLevel,
    )
}
