@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ManagedDiskDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the managed disks.
 * @property dataAccountType Account Type of the data to be transferred.
 * Expected value is 'ManagedDisk'.
 * @property resourceGroupId Resource Group Id of the compute disks.
 * @property sharePassword Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
 * @property stagingStorageAccountId Resource Id of the storage account that can be used to copy the vhd for staging.
 */
public data class ManagedDiskDetailsArgs(
    public val dataAccountType: Output<String>,
    public val resourceGroupId: Output<String>,
    public val sharePassword: Output<String>? = null,
    public val stagingStorageAccountId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ManagedDiskDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ManagedDiskDetailsArgs =
        com.pulumi.azurenative.databox.inputs.ManagedDiskDetailsArgs.builder()
            .dataAccountType(dataAccountType.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId.applyValue({ args0 -> args0 }))
            .sharePassword(sharePassword?.applyValue({ args0 -> args0 }))
            .stagingStorageAccountId(stagingStorageAccountId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedDiskDetailsArgs].
 */
@PulumiTagMarker
public class ManagedDiskDetailsArgsBuilder internal constructor() {
    private var dataAccountType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var sharePassword: Output<String>? = null

    private var stagingStorageAccountId: Output<String>? = null

    /**
     * @param value Account Type of the data to be transferred.
     * Expected value is 'ManagedDisk'.
     */
    @JvmName("flkvwjttkngnurwc")
    public suspend fun dataAccountType(`value`: Output<String>) {
        this.dataAccountType = value
    }

    /**
     * @param value Resource Group Id of the compute disks.
     */
    @JvmName("upubernwfusntqof")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
     */
    @JvmName("lrfdltgcekmsshxy")
    public suspend fun sharePassword(`value`: Output<String>) {
        this.sharePassword = value
    }

    /**
     * @param value Resource Id of the storage account that can be used to copy the vhd for staging.
     */
    @JvmName("yurmmjeqislhkwxg")
    public suspend fun stagingStorageAccountId(`value`: Output<String>) {
        this.stagingStorageAccountId = value
    }

    /**
     * @param value Account Type of the data to be transferred.
     * Expected value is 'ManagedDisk'.
     */
    @JvmName("iodaoetuunjhbrvx")
    public suspend fun dataAccountType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Resource Group Id of the compute disks.
     */
    @JvmName("yuyxerwecdshfqty")
    public suspend fun resourceGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
     */
    @JvmName("nctlxmkfgiehmusy")
    public suspend fun sharePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharePassword = mapped
    }

    /**
     * @param value Resource Id of the storage account that can be used to copy the vhd for staging.
     */
    @JvmName("olwfeogavqgxawak")
    public suspend fun stagingStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stagingStorageAccountId = mapped
    }

    internal fun build(): ManagedDiskDetailsArgs = ManagedDiskDetailsArgs(
        dataAccountType = dataAccountType ?: throw PulumiNullFieldException("dataAccountType"),
        resourceGroupId = resourceGroupId ?: throw PulumiNullFieldException("resourceGroupId"),
        sharePassword = sharePassword,
        stagingStorageAccountId = stagingStorageAccountId ?: throw
            PulumiNullFieldException("stagingStorageAccountId"),
    )
}
