@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.NotificationPreferenceArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.NotificationStageName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Notification preference for a job stage.
 * @property sendNotification Notification is required or not.
 * @property stageName Name of the stage.
 */
public data class NotificationPreferenceArgs(
    public val sendNotification: Output<Boolean>,
    public val stageName: Output<Either<String, NotificationStageName>>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.NotificationPreferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.NotificationPreferenceArgs =
        com.pulumi.azurenative.databox.inputs.NotificationPreferenceArgs.builder()
            .sendNotification(sendNotification.applyValue({ args0 -> args0 }))
            .stageName(
                stageName.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationPreferenceArgs].
 */
@PulumiTagMarker
public class NotificationPreferenceArgsBuilder internal constructor() {
    private var sendNotification: Output<Boolean>? = null

    private var stageName: Output<Either<String, NotificationStageName>>? = null

    /**
     * @param value Notification is required or not.
     */
    @JvmName("nulocwpwekrmjvub")
    public suspend fun sendNotification(`value`: Output<Boolean>) {
        this.sendNotification = value
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("lctbqsnpeyyrmhno")
    public suspend fun stageName(`value`: Output<Either<String, NotificationStageName>>) {
        this.stageName = value
    }

    /**
     * @param value Notification is required or not.
     */
    @JvmName("ewgklyavvrbglpku")
    public suspend fun sendNotification(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendNotification = mapped
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("utagscjwkyweiswc")
    public suspend fun stageName(`value`: Either<String, NotificationStageName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("nmtsaaaojjenoraw")
    public fun stageName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotificationStageName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("gyjpwxwbgedxvkay")
    public fun stageName(`value`: NotificationStageName) {
        val toBeMapped = Either.ofRight<String, NotificationStageName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): NotificationPreferenceArgs = NotificationPreferenceArgs(
        sendNotification = sendNotification ?: throw PulumiNullFieldException("sendNotification"),
        stageName = stageName ?: throw PulumiNullFieldException("stageName"),
    )
}
