@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.PackageCarrierDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Package carrier details.
 * @property carrierAccountNumber Carrier Account Number of customer for customer disk.
 * @property carrierName Name of the carrier.
 * @property trackingId Tracking Id of shipment.
 */
public data class PackageCarrierDetailsArgs(
    public val carrierAccountNumber: Output<String>? = null,
    public val carrierName: Output<String>? = null,
    public val trackingId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.PackageCarrierDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.PackageCarrierDetailsArgs =
        com.pulumi.azurenative.databox.inputs.PackageCarrierDetailsArgs.builder()
            .carrierAccountNumber(carrierAccountNumber?.applyValue({ args0 -> args0 }))
            .carrierName(carrierName?.applyValue({ args0 -> args0 }))
            .trackingId(trackingId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageCarrierDetailsArgs].
 */
@PulumiTagMarker
public class PackageCarrierDetailsArgsBuilder internal constructor() {
    private var carrierAccountNumber: Output<String>? = null

    private var carrierName: Output<String>? = null

    private var trackingId: Output<String>? = null

    /**
     * @param value Carrier Account Number of customer for customer disk.
     */
    @JvmName("oxhwnrnsrjguypyw")
    public suspend fun carrierAccountNumber(`value`: Output<String>) {
        this.carrierAccountNumber = value
    }

    /**
     * @param value Name of the carrier.
     */
    @JvmName("mduacaefhpfhxexc")
    public suspend fun carrierName(`value`: Output<String>) {
        this.carrierName = value
    }

    /**
     * @param value Tracking Id of shipment.
     */
    @JvmName("mnvewjbjwwtqleku")
    public suspend fun trackingId(`value`: Output<String>) {
        this.trackingId = value
    }

    /**
     * @param value Carrier Account Number of customer for customer disk.
     */
    @JvmName("fvvfomyvtplynfeq")
    public suspend fun carrierAccountNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.carrierAccountNumber = mapped
    }

    /**
     * @param value Name of the carrier.
     */
    @JvmName("mffcogsqurvceqdx")
    public suspend fun carrierName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.carrierName = mapped
    }

    /**
     * @param value Tracking Id of shipment.
     */
    @JvmName("qqcrwppwpejvcnrd")
    public suspend fun trackingId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackingId = mapped
    }

    internal fun build(): PackageCarrierDetailsArgs = PackageCarrierDetailsArgs(
        carrierAccountNumber = carrierAccountNumber,
        carrierName = carrierName,
        trackingId = trackingId,
    )
}
