@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.TransferAllDetailsArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.DataAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details to transfer all data.
 * @property dataAccountType Type of the account of data
 * @property transferAllBlobs To indicate if all Azure blobs have to be transferred
 * @property transferAllFiles To indicate if all Azure Files have to be transferred
 */
public data class TransferAllDetailsArgs(
    public val dataAccountType: Output<Either<String, DataAccountType>>,
    public val transferAllBlobs: Output<Boolean>? = null,
    public val transferAllFiles: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.TransferAllDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.TransferAllDetailsArgs =
        com.pulumi.azurenative.databox.inputs.TransferAllDetailsArgs.builder()
            .dataAccountType(
                dataAccountType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transferAllBlobs(transferAllBlobs?.applyValue({ args0 -> args0 }))
            .transferAllFiles(transferAllFiles?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransferAllDetailsArgs].
 */
@PulumiTagMarker
public class TransferAllDetailsArgsBuilder internal constructor() {
    private var dataAccountType: Output<Either<String, DataAccountType>>? = null

    private var transferAllBlobs: Output<Boolean>? = null

    private var transferAllFiles: Output<Boolean>? = null

    /**
     * @param value Type of the account of data
     */
    @JvmName("pydmedudjmlcwafx")
    public suspend fun dataAccountType(`value`: Output<Either<String, DataAccountType>>) {
        this.dataAccountType = value
    }

    /**
     * @param value To indicate if all Azure blobs have to be transferred
     */
    @JvmName("liuoonyhbwhwlsgk")
    public suspend fun transferAllBlobs(`value`: Output<Boolean>) {
        this.transferAllBlobs = value
    }

    /**
     * @param value To indicate if all Azure Files have to be transferred
     */
    @JvmName("uoqkreiggfubpbse")
    public suspend fun transferAllFiles(`value`: Output<Boolean>) {
        this.transferAllFiles = value
    }

    /**
     * @param value Type of the account of data
     */
    @JvmName("icwtlbmbyeoerbve")
    public suspend fun dataAccountType(`value`: Either<String, DataAccountType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Type of the account of data
     */
    @JvmName("ctqpgaerpkfkxsgy")
    public fun dataAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Type of the account of data
     */
    @JvmName("uyiaeoyxfxddmjuj")
    public fun dataAccountType(`value`: DataAccountType) {
        val toBeMapped = Either.ofRight<String, DataAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value To indicate if all Azure blobs have to be transferred
     */
    @JvmName("hashcscqpiwpaivw")
    public suspend fun transferAllBlobs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferAllBlobs = mapped
    }

    /**
     * @param value To indicate if all Azure Files have to be transferred
     */
    @JvmName("khnrvsvokeysacgo")
    public suspend fun transferAllFiles(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferAllFiles = mapped
    }

    internal fun build(): TransferAllDetailsArgs = TransferAllDetailsArgs(
        dataAccountType = dataAccountType ?: throw PulumiNullFieldException("dataAccountType"),
        transferAllBlobs = transferAllBlobs,
        transferAllFiles = transferAllFiles,
    )
}
