@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.TransferFilterDetailsArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.DataAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details of the filtering the transfer of data.
 * @property azureFileFilterDetails Filter details to transfer Azure files.
 * @property blobFilterDetails Filter details to transfer blobs.
 * @property dataAccountType Type of the account of data.
 * @property filterFileDetails Details of the filter files to be used for data transfer.
 */
public data class TransferFilterDetailsArgs(
    public val azureFileFilterDetails: Output<AzureFileFilterDetailsArgs>? = null,
    public val blobFilterDetails: Output<BlobFilterDetailsArgs>? = null,
    public val dataAccountType: Output<Either<String, DataAccountType>>,
    public val filterFileDetails: Output<List<FilterFileDetailsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.TransferFilterDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.TransferFilterDetailsArgs =
        com.pulumi.azurenative.databox.inputs.TransferFilterDetailsArgs.builder()
            .azureFileFilterDetails(
                azureFileFilterDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .blobFilterDetails(blobFilterDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataAccountType(
                dataAccountType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filterFileDetails(
                filterFileDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TransferFilterDetailsArgs].
 */
@PulumiTagMarker
public class TransferFilterDetailsArgsBuilder internal constructor() {
    private var azureFileFilterDetails: Output<AzureFileFilterDetailsArgs>? = null

    private var blobFilterDetails: Output<BlobFilterDetailsArgs>? = null

    private var dataAccountType: Output<Either<String, DataAccountType>>? = null

    private var filterFileDetails: Output<List<FilterFileDetailsArgs>>? = null

    /**
     * @param value Filter details to transfer Azure files.
     */
    @JvmName("jcfbhxgohvuhqtrv")
    public suspend fun azureFileFilterDetails(`value`: Output<AzureFileFilterDetailsArgs>) {
        this.azureFileFilterDetails = value
    }

    /**
     * @param value Filter details to transfer blobs.
     */
    @JvmName("wmdnuqobjvipvcgv")
    public suspend fun blobFilterDetails(`value`: Output<BlobFilterDetailsArgs>) {
        this.blobFilterDetails = value
    }

    /**
     * @param value Type of the account of data.
     */
    @JvmName("qiacujxwjxmfqdjy")
    public suspend fun dataAccountType(`value`: Output<Either<String, DataAccountType>>) {
        this.dataAccountType = value
    }

    /**
     * @param value Details of the filter files to be used for data transfer.
     */
    @JvmName("wwpoafthyqplklik")
    public suspend fun filterFileDetails(`value`: Output<List<FilterFileDetailsArgs>>) {
        this.filterFileDetails = value
    }

    @JvmName("cwaevohkmivssxeb")
    public suspend fun filterFileDetails(vararg values: Output<FilterFileDetailsArgs>) {
        this.filterFileDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the filter files to be used for data transfer.
     */
    @JvmName("ogypcekwegissble")
    public suspend fun filterFileDetails(values: List<Output<FilterFileDetailsArgs>>) {
        this.filterFileDetails = Output.all(values)
    }

    /**
     * @param value Filter details to transfer Azure files.
     */
    @JvmName("byslyjpuomdrukqa")
    public suspend fun azureFileFilterDetails(`value`: AzureFileFilterDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileFilterDetails = mapped
    }

    /**
     * @param argument Filter details to transfer Azure files.
     */
    @JvmName("sxuqdooqdqmahhya")
    public suspend
    fun azureFileFilterDetails(argument: suspend AzureFileFilterDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileFilterDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFileFilterDetails = mapped
    }

    /**
     * @param value Filter details to transfer blobs.
     */
    @JvmName("nqbhhwrcyoelalgb")
    public suspend fun blobFilterDetails(`value`: BlobFilterDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobFilterDetails = mapped
    }

    /**
     * @param argument Filter details to transfer blobs.
     */
    @JvmName("frmdccbqfjuocegt")
    public suspend fun blobFilterDetails(argument: suspend BlobFilterDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = BlobFilterDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.blobFilterDetails = mapped
    }

    /**
     * @param value Type of the account of data.
     */
    @JvmName("gwtbhbnbmihbqtsg")
    public suspend fun dataAccountType(`value`: Either<String, DataAccountType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Type of the account of data.
     */
    @JvmName("jmksqsgjaaseevrt")
    public fun dataAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Type of the account of data.
     */
    @JvmName("cxxffdwdsuyftyfo")
    public fun dataAccountType(`value`: DataAccountType) {
        val toBeMapped = Either.ofRight<String, DataAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Details of the filter files to be used for data transfer.
     */
    @JvmName("hqkwtpfhiwylioqv")
    public suspend fun filterFileDetails(`value`: List<FilterFileDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterFileDetails = mapped
    }

    /**
     * @param argument Details of the filter files to be used for data transfer.
     */
    @JvmName("soqgumdxpcdjylpc")
    public suspend
    fun filterFileDetails(argument: List<suspend FilterFileDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterFileDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filterFileDetails = mapped
    }

    /**
     * @param argument Details of the filter files to be used for data transfer.
     */
    @JvmName("vvskvdpwmnddpcmd")
    public suspend fun filterFileDetails(
        vararg
        argument: suspend FilterFileDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FilterFileDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filterFileDetails = mapped
    }

    /**
     * @param argument Details of the filter files to be used for data transfer.
     */
    @JvmName("lpmrbbkkflrlqubp")
    public suspend fun filterFileDetails(argument: suspend FilterFileDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterFileDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filterFileDetails = mapped
    }

    /**
     * @param values Details of the filter files to be used for data transfer.
     */
    @JvmName("usyxvkaxfavqchsn")
    public suspend fun filterFileDetails(vararg values: FilterFileDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterFileDetails = mapped
    }

    internal fun build(): TransferFilterDetailsArgs = TransferFilterDetailsArgs(
        azureFileFilterDetails = azureFileFilterDetails,
        blobFilterDetails = blobFilterDetails,
        dataAccountType = dataAccountType ?: throw PulumiNullFieldException("dataAccountType"),
        filterFileDetails = filterFileDetails,
    )
}
