@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Copy progress.
 * @property accountId Id of the account where the data needs to be uploaded.
 * @property actions Available actions on the job.
 * @property bytesProcessed To indicate bytes transferred.
 * @property dataAccountType Data Account Type.
 * @property directoriesErroredOut To indicate directories errored out in the job.
 * @property error Error, if any, in the stage
 * @property filesErroredOut Number of files which could not be copied
 * @property filesProcessed Number of files processed
 * @property invalidDirectoriesProcessed To indicate directories renamed
 * @property invalidFileBytesUploaded Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
 * @property invalidFilesProcessed Number of files not adhering to azure naming conventions which were processed by automatic renaming
 * @property isEnumerationInProgress To indicate if enumeration of data is in progress.
 * Until this is true, the TotalBytesToProcess may not be valid.
 * @property renamedContainerCount Number of folders not adhering to azure naming conventions which were processed by automatic renaming
 * @property storageAccountName Name of the storage account. This will be empty for data account types other than storage account.
 * @property totalBytesToProcess Total amount of data to be processed by the job.
 * @property totalFilesToProcess Total files to process
 * @property transferType Transfer type of data
 */
public data class CopyProgressResponse(
    public val accountId: String,
    public val actions: List<String>,
    public val bytesProcessed: Double,
    public val dataAccountType: String,
    public val directoriesErroredOut: Double,
    public val error: CloudErrorResponse,
    public val filesErroredOut: Double,
    public val filesProcessed: Double,
    public val invalidDirectoriesProcessed: Double,
    public val invalidFileBytesUploaded: Double,
    public val invalidFilesProcessed: Double,
    public val isEnumerationInProgress: Boolean,
    public val renamedContainerCount: Double,
    public val storageAccountName: String,
    public val totalBytesToProcess: Double,
    public val totalFilesToProcess: Double,
    public val transferType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.CopyProgressResponse):
            CopyProgressResponse = CopyProgressResponse(
            accountId = javaType.accountId(),
            actions = javaType.actions().map({ args0 -> args0 }),
            bytesProcessed = javaType.bytesProcessed(),
            dataAccountType = javaType.dataAccountType(),
            directoriesErroredOut = javaType.directoriesErroredOut(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
            }),
            filesErroredOut = javaType.filesErroredOut(),
            filesProcessed = javaType.filesProcessed(),
            invalidDirectoriesProcessed = javaType.invalidDirectoriesProcessed(),
            invalidFileBytesUploaded = javaType.invalidFileBytesUploaded(),
            invalidFilesProcessed = javaType.invalidFilesProcessed(),
            isEnumerationInProgress = javaType.isEnumerationInProgress(),
            renamedContainerCount = javaType.renamedContainerCount(),
            storageAccountName = javaType.storageAccountName(),
            totalBytesToProcess = javaType.totalBytesToProcess(),
            totalFilesToProcess = javaType.totalFilesToProcess(),
            transferType = javaType.transferType(),
        )
    }
}
