@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Granular Copy Log Details for customer disk
 * @property accountId Account id.
 * @property copyLogDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxCustomerDisk'.
 * @property errorLogLink Link for copy error logs.
 * @property serialNumber Disk Serial Number.
 * @property verboseLogLink Link for copy verbose logs.
 */
public data class DataBoxDiskGranularCopyLogDetailsResponse(
    public val accountId: String,
    public val copyLogDetailsType: String,
    public val errorLogLink: String,
    public val serialNumber: String,
    public val verboseLogLink: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxDiskGranularCopyLogDetailsResponse):
            DataBoxDiskGranularCopyLogDetailsResponse = DataBoxDiskGranularCopyLogDetailsResponse(
            accountId = javaType.accountId(),
            copyLogDetailsType = javaType.copyLogDetailsType(),
            errorLogLink = javaType.errorLogLink(),
            serialNumber = javaType.serialNumber(),
            verboseLogLink = javaType.verboseLogLink(),
        )
    }
}
