@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains all the secrets of a Disk.
 * @property bitLockerKey Bit Locker key of the disk which can be used to unlock the disk to copy data.
 * @property diskSerialNumber Serial number of the assigned disk.
 */
public data class DiskSecretResponse(
    public val bitLockerKey: String,
    public val diskSerialNumber: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DiskSecretResponse):
            DiskSecretResponse = DiskSecretResponse(
            bitLockerKey = javaType.bitLockerKey(),
            diskSerialNumber = javaType.diskSerialNumber(),
        )
    }
}
