@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Export disk details
 * @property backupManifestCloudPath Path to backed up manifest, only returned if enableManifestBackup is true.
 * @property manifestFile The relative path of the manifest file on the disk.
 * @property manifestHash The Base16-encoded MD5 hash of the manifest file on the disk.
 */
public data class ExportDiskDetailsResponse(
    public val backupManifestCloudPath: String,
    public val manifestFile: String,
    public val manifestHash: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ExportDiskDetailsResponse):
            ExportDiskDetailsResponse = ExportDiskDetailsResponse(
            backupManifestCloudPath = javaType.backupManifestCloudPath(),
            manifestFile = javaType.manifestFile(),
            manifestHash = javaType.manifestHash(),
        )
    }
}
