@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.DeviceArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.DataResidencyArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.DataResidencyArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-05-01-preview, 2021-02-01, 2021-02-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01.
 * ## Example Usage
 * ### DataBoxEdgeDevicePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.DataBoxEdge.Device("device", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Location = "WUS",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         Sku = new AzureNative.DataBoxEdge.Inputs.SkuArgs
 *         {
 *             Name = "Edge",
 *             Tier = "Standard",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewDevice(ctx, "device", &databoxedge.DeviceArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Location:          pulumi.String("WUS"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			Sku: &databoxedge.SkuArgs{
 * 				Name: pulumi.String("Edge"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Device;
 * import com.pulumi.azurenative.databoxedge.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .deviceName("testedgedevice")
 *             .location("WUS")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Edge"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### DataBoxEdgeDevicePutWithDataResidency
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.DataBoxEdge.Device("device", new()
 *     {
 *         DataResidency = new AzureNative.DataBoxEdge.Inputs.DataResidencyArgs
 *         {
 *             Type = "ZoneReplication",
 *         },
 *         DeviceName = "testedgedevice",
 *         Location = "WUS",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         Sku = new AzureNative.DataBoxEdge.Inputs.SkuArgs
 *         {
 *             Name = "Edge",
 *             Tier = "Standard",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewDevice(ctx, "device", &databoxedge.DeviceArgs{
 * 			DataResidency: &databoxedge.DataResidencyArgs{
 * 				Type: pulumi.String("ZoneReplication"),
 * 			},
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Location:          pulumi.String("WUS"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			Sku: &databoxedge.SkuArgs{
 * 				Name: pulumi.String("Edge"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Device;
 * import com.pulumi.azurenative.databoxedge.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .dataResidency(Map.of("type", "ZoneReplication"))
 *             .deviceName("testedgedevice")
 *             .location("WUS")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Edge"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Device testedgedevice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}
 * ```
 * @property dataResidency The details of data-residency related properties for this resource
 * @property deviceName The device name.
 * @property identity Msi identity of the resource
 * @property location The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
 * @property resourceGroupName The resource group name.
 * @property sku The SKU type.
 * @property tags The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
 */
public data class DeviceArgs(
    public val dataResidency: Output<DataResidencyArgs>? = null,
    public val deviceName: Output<String>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.DeviceArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.DeviceArgs =
        com.pulumi.azurenative.databoxedge.DeviceArgs.builder()
            .dataResidency(dataResidency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeviceArgs].
 */
@PulumiTagMarker
public class DeviceArgsBuilder internal constructor() {
    private var dataResidency: Output<DataResidencyArgs>? = null

    private var deviceName: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The details of data-residency related properties for this resource
     */
    @JvmName("aydotmbhaahbbngu")
    public suspend fun dataResidency(`value`: Output<DataResidencyArgs>) {
        this.dataResidency = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("mwauqrmkrlaxhaib")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Msi identity of the resource
     */
    @JvmName("nkrmrqviyjaiwtsk")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
     */
    @JvmName("aypkiqjnqnqsivhe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("gqmulkockuuaarny")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU type.
     */
    @JvmName("ydgtuehwcuyacuci")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
     */
    @JvmName("vsembqaxgbaeliai")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The details of data-residency related properties for this resource
     */
    @JvmName("aoaeydbuklgomgoy")
    public suspend fun dataResidency(`value`: DataResidencyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataResidency = mapped
    }

    /**
     * @param argument The details of data-residency related properties for this resource
     */
    @JvmName("xylkgyuxavherthk")
    public suspend fun dataResidency(argument: suspend DataResidencyArgsBuilder.() -> Unit) {
        val toBeMapped = DataResidencyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataResidency = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("wedlglwidpblabmh")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Msi identity of the resource
     */
    @JvmName("qugvuotrmhkqexwr")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Msi identity of the resource
     */
    @JvmName("ppwxamhtgallfsvi")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
     */
    @JvmName("wmqikitmectiemsm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ssrrrkeerpqjrmph")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU type.
     */
    @JvmName("vodiyjwundvydyeo")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU type.
     */
    @JvmName("pfjsfqpuxqydhbgk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
     */
    @JvmName("tkmybpwkpernojyr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
     */
    @JvmName("jiouwmmdxctvdxel")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeviceArgs = DeviceArgs(
        dataResidency = dataResidency,
        deviceName = deviceName,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
